@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin

import com.pulumi.azurenative.servicelinker.kotlin.outputs.BasicErrorDryrunPrerequisiteResultResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.CreateOrUpdateDryrunParametersResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.DryrunOperationPreviewResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.PermissionsMissingDryrunPrerequisiteResultResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.servicelinker.kotlin.outputs.CreateOrUpdateDryrunParametersResponse.Companion.toKotlin as createOrUpdateDryrunParametersResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.DryrunOperationPreviewResponse.Companion.toKotlin as dryrunOperationPreviewResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LinkerDryrun].
 */
@PulumiTagMarker
public class LinkerDryrunResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkerDryrunArgs = LinkerDryrunArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkerDryrunArgsBuilder.() -> Unit) {
        val builder = LinkerDryrunArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LinkerDryrun {
        val builtJavaResource =
            com.pulumi.azurenative.servicelinker.LinkerDryrun(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LinkerDryrun(builtJavaResource)
    }
}

/**
 * a dryrun job resource
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### PutDryrun
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkerDryrun = new AzureNative.ServiceLinker.LinkerDryrun("linkerDryrun", new()
 *     {
 *         DryrunName = "dryrunName",
 *         Parameters = new AzureNative.ServiceLinker.Inputs.CreateOrUpdateDryrunParametersArgs
 *         {
 *             ActionName = "createOrUpdate",
 *             AuthInfo = new AzureNative.ServiceLinker.Inputs.SecretAuthInfoArgs
 *             {
 *                 AuthType = "secret",
 *                 Name = "name",
 *                 SecretInfo = new AzureNative.ServiceLinker.Inputs.ValueSecretInfoArgs
 *                 {
 *                     SecretType = "rawValue",
 *                     Value = "secret",
 *                 },
 *             },
 *             TargetService = new AzureNative.ServiceLinker.Inputs.AzureResourceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db",
 *                 Type = "AzureResource",
 *             },
 *         },
 *         ResourceUri = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicelinker/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicelinker.NewLinkerDryrun(ctx, "linkerDryrun", &servicelinker.LinkerDryrunArgs{
 * 			DryrunName: pulumi.String("dryrunName"),
 * 			Parameters: &servicelinker.CreateOrUpdateDryrunParametersArgs{
 * 				ActionName: pulumi.String("createOrUpdate"),
 * 				AuthInfo: servicelinker.SecretAuthInfo{
 * 					AuthType: "secret",
 * 					Name:     "name",
 * 					SecretInfo: servicelinker.ValueSecretInfo{
 * 						SecretType: "rawValue",
 * 						Value:      "secret",
 * 					},
 * 				},
 * 				TargetService: servicelinker.AzureResource{
 * 					Id:   "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db",
 * 					Type: "AzureResource",
 * 				},
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicelinker.LinkerDryrun;
 * import com.pulumi.azurenative.servicelinker.LinkerDryrunArgs;
 * import com.pulumi.azurenative.servicelinker.inputs.CreateOrUpdateDryrunParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkerDryrun = new LinkerDryrun("linkerDryrun", LinkerDryrunArgs.builder()
 *             .dryrunName("dryrunName")
 *             .parameters(CreateOrUpdateDryrunParametersArgs.builder()
 *                 .actionName("createOrUpdate")
 *                 .authInfo(AccessKeyInfoBaseArgs.builder()
 *                     .authType("secret")
 *                     .name("name")
 *                     .secretInfo(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .targetService(AzureResourceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db")
 *                     .type("AzureResource")
 *                     .build())
 *                 .build())
 *             .resourceUri("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicelinker:LinkerDryrun dryrunName /{resourceUri}/providers/Microsoft.ServiceLinker/dryruns/{dryrunName}
 * ```
 */
public class LinkerDryrun internal constructor(
    override val javaResource: com.pulumi.azurenative.servicelinker.LinkerDryrun,
) : KotlinCustomResource(javaResource, LinkerDryrunMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the preview of the operations for creation
     */
    public val operationPreviews: Output<List<DryrunOperationPreviewResponse>>
        get() = javaResource.operationPreviews().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dryrunOperationPreviewResponseToKotlin(args0) })
            })
        })

    /**
     * The parameters of the dryrun
     */
    public val parameters: Output<CreateOrUpdateDryrunParametersResponse>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    createOrUpdateDryrunParametersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * the result of the dryrun
     */
    public val prerequisiteResults:
        Output<List<Either<BasicErrorDryrunPrerequisiteResultResponse, PermissionsMissingDryrunPrerequisiteResultResponse>>>
        get() = javaResource.prerequisiteResults().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.servicelinker.kotlin.outputs.BasicErrorDryrunPrerequisiteResultResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.servicelinker.kotlin.outputs.PermissionsMissingDryrunPrerequisiteResultResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            })
        })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LinkerDryrunMapper : ResourceMapper<LinkerDryrun> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicelinker.LinkerDryrun::class == javaResource::class

    override fun map(javaResource: Resource): LinkerDryrun = LinkerDryrun(
        javaResource as
            com.pulumi.azurenative.servicelinker.LinkerDryrun,
    )
}

/**
 * @see [LinkerDryrun].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkerDryrun].
 */
public suspend fun linkerDryrun(
    name: String,
    block: suspend LinkerDryrunResourceBuilder.() -> Unit,
): LinkerDryrun {
    val builder = LinkerDryrunResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkerDryrun].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkerDryrun(name: String): LinkerDryrun {
    val builder = LinkerDryrunResourceBuilder()
    builder.name(name)
    return builder.build()
}
