@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
 */
public enum class AllowType(
    public val javaValue: com.pulumi.azurenative.servicelinker.enums.AllowType,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.enums.AllowType> {
    True_(com.pulumi.azurenative.servicelinker.enums.AllowType.True_),
    False_(com.pulumi.azurenative.servicelinker.enums.AllowType.False_),
    ;

    override fun toJava(): com.pulumi.azurenative.servicelinker.enums.AllowType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.enums.AllowType): AllowType =
            AllowType.values().first { it.javaValue == javaType }
    }
}
