@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.AccessKeyInfoBaseArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.AccessKeyPermissions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The access key directly from target resource properties, which target service is Azure Resource, such as Microsoft.Storage
 * @property authType The authentication type.
 * Expected value is 'accessKey'.
 * @property permissions Permissions of the accessKey. `Read` and `Write` are for Azure Cosmos DB and Azure App Configuration, `Listen`, `Send` and `Manage` are for Azure Event Hub and Azure Service Bus.
 */
public data class AccessKeyInfoBaseArgs(
    public val authType: Output<String>,
    public val permissions: Output<List<Either<String, AccessKeyPermissions>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.AccessKeyInfoBaseArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.AccessKeyInfoBaseArgs =
        com.pulumi.azurenative.servicelinker.inputs.AccessKeyInfoBaseArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccessKeyInfoBaseArgs].
 */
@PulumiTagMarker
public class AccessKeyInfoBaseArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var permissions: Output<List<Either<String, AccessKeyPermissions>>>? = null

    /**
     * @param value The authentication type.
     * Expected value is 'accessKey'.
     */
    @JvmName("vejlkcavebhdrhgp")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Permissions of the accessKey. `Read` and `Write` are for Azure Cosmos DB and Azure App Configuration, `Listen`, `Send` and `Manage` are for Azure Event Hub and Azure Service Bus.
     */
    @JvmName("rihsltboxfcgufse")
    public suspend fun permissions(`value`: Output<List<Either<String, AccessKeyPermissions>>>) {
        this.permissions = value
    }

    @JvmName("yearsvqggvxyerps")
    public suspend fun permissions(vararg values: Output<Either<String, AccessKeyPermissions>>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values Permissions of the accessKey. `Read` and `Write` are for Azure Cosmos DB and Azure App Configuration, `Listen`, `Send` and `Manage` are for Azure Event Hub and Azure Service Bus.
     */
    @JvmName("lehvtvhoadomgxhg")
    public suspend fun permissions(values: List<Output<Either<String, AccessKeyPermissions>>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The authentication type.
     * Expected value is 'accessKey'.
     */
    @JvmName("jowyvprsbsnbxtpl")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Permissions of the accessKey. `Read` and `Write` are for Azure Cosmos DB and Azure App Configuration, `Listen`, `Send` and `Manage` are for Azure Event Hub and Azure Service Bus.
     */
    @JvmName("ueylqrrnejvwdvwy")
    public suspend fun permissions(`value`: List<Either<String, AccessKeyPermissions>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param values Permissions of the accessKey. `Read` and `Write` are for Azure Cosmos DB and Azure App Configuration, `Listen`, `Send` and `Manage` are for Azure Event Hub and Azure Service Bus.
     */
    @JvmName("pxdcnnrvrnxgsitx")
    public suspend fun permissions(vararg values: Either<String, AccessKeyPermissions>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    internal fun build(): AccessKeyInfoBaseArgs = AccessKeyInfoBaseArgs(
        authType = authType ?: throw PulumiNullFieldException("authType"),
        permissions = permissions,
    )
}
