@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.AzureKeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The resource properties when type is Azure Key Vault
 * @property connectAsKubernetesCsiDriver True if connect via Kubernetes CSI Driver.
 * @property type The azure resource type.
 * Expected value is 'KeyVault'.
 */
public data class AzureKeyVaultPropertiesArgs(
    public val connectAsKubernetesCsiDriver: Output<Boolean>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.AzureKeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.AzureKeyVaultPropertiesArgs =
        com.pulumi.azurenative.servicelinker.inputs.AzureKeyVaultPropertiesArgs.builder()
            .connectAsKubernetesCsiDriver(connectAsKubernetesCsiDriver?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureKeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class AzureKeyVaultPropertiesArgsBuilder internal constructor() {
    private var connectAsKubernetesCsiDriver: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value True if connect via Kubernetes CSI Driver.
     */
    @JvmName("ksmuiqpbtkxxrudv")
    public suspend fun connectAsKubernetesCsiDriver(`value`: Output<Boolean>) {
        this.connectAsKubernetesCsiDriver = value
    }

    /**
     * @param value The azure resource type.
     * Expected value is 'KeyVault'.
     */
    @JvmName("plrkwtgtxnqbongo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value True if connect via Kubernetes CSI Driver.
     */
    @JvmName("xpncnmlpjlqxvqmq")
    public suspend fun connectAsKubernetesCsiDriver(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectAsKubernetesCsiDriver = mapped
    }

    /**
     * @param value The azure resource type.
     * Expected value is 'KeyVault'.
     */
    @JvmName("fkstcietflxmaxiw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureKeyVaultPropertiesArgs = AzureKeyVaultPropertiesArgs(
        connectAsKubernetesCsiDriver = connectAsKubernetesCsiDriver,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
