@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.ConfluentBootstrapServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The service properties when target service type is ConfluentBootstrapServer
 * @property endpoint The endpoint of service.
 * @property type The target service type.
 * Expected value is 'ConfluentBootstrapServer'.
 */
public data class ConfluentBootstrapServerArgs(
    public val endpoint: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.ConfluentBootstrapServerArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.ConfluentBootstrapServerArgs =
        com.pulumi.azurenative.servicelinker.inputs.ConfluentBootstrapServerArgs.builder()
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfluentBootstrapServerArgs].
 */
@PulumiTagMarker
public class ConfluentBootstrapServerArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The endpoint of service.
     */
    @JvmName("mqmcgaatqqyyrnvf")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The target service type.
     * Expected value is 'ConfluentBootstrapServer'.
     */
    @JvmName("nhylyqrtqkrwcdeg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The endpoint of service.
     */
    @JvmName("djqjecnhppfbhpxq")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The target service type.
     * Expected value is 'ConfluentBootstrapServer'.
     */
    @JvmName("bsdbyueaqorhjkrc")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConfluentBootstrapServerArgs = ConfluentBootstrapServerArgs(
        endpoint = endpoint,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
