@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.GetConnectorDryrunPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dryrunName The name of dryrun.
 * @property location The name of Azure region.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subscriptionId The ID of the target subscription.
 */
public data class GetConnectorDryrunPlainArgs(
    public val dryrunName: String,
    public val location: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.GetConnectorDryrunPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.GetConnectorDryrunPlainArgs =
        com.pulumi.azurenative.servicelinker.inputs.GetConnectorDryrunPlainArgs.builder()
            .dryrunName(dryrunName.let({ args0 -> args0 }))
            .location(location.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectorDryrunPlainArgs].
 */
@PulumiTagMarker
public class GetConnectorDryrunPlainArgsBuilder internal constructor() {
    private var dryrunName: String? = null

    private var location: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value The name of dryrun.
     */
    @JvmName("kwndopqkthdoyrcf")
    public suspend fun dryrunName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dryrunName = mapped
    }

    /**
     * @param value The name of Azure region.
     */
    @JvmName("ygnkodcmdqqomvrw")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eycuceekysjeqdpm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ID of the target subscription.
     */
    @JvmName("gvrivsgdgueexnnr")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): GetConnectorDryrunPlainArgs = GetConnectorDryrunPlainArgs(
        dryrunName = dryrunName ?: throw PulumiNullFieldException("dryrunName"),
        location = location ?: throw PulumiNullFieldException("location"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
    )
}
