@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.UserAssignedIdentityAuthInfoArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.DeleteOrUpdateBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The authentication info when authType is userAssignedIdentity
 * @property authType The authentication type.
 * Expected value is 'userAssignedIdentity'.
 * @property clientId Client Id for userAssignedIdentity.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property roles Optional, this value specifies the Azure role to be assigned
 * @property subscriptionId Subscription id for userAssignedIdentity.
 * @property userName Username created in the database which is mapped to a user in AAD.
 */
public data class UserAssignedIdentityAuthInfoArgs(
    public val authType: Output<String>,
    public val clientId: Output<String>? = null,
    public val deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null,
    public val roles: Output<List<String>>? = null,
    public val subscriptionId: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.UserAssignedIdentityAuthInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicelinker.inputs.UserAssignedIdentityAuthInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.UserAssignedIdentityAuthInfoArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .deleteOrUpdateBehavior(
                deleteOrUpdateBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedIdentityAuthInfoArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityAuthInfoArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var clientId: Output<String>? = null

    private var deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null

    private var roles: Output<List<String>>? = null

    private var subscriptionId: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The authentication type.
     * Expected value is 'userAssignedIdentity'.
     */
    @JvmName("esckgjxxenmkpcpa")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Client Id for userAssignedIdentity.
     */
    @JvmName("yvnnrcjsehydiaod")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("diojyckbcyembhrl")
    public suspend
    fun deleteOrUpdateBehavior(`value`: Output<Either<String, DeleteOrUpdateBehavior>>) {
        this.deleteOrUpdateBehavior = value
    }

    /**
     * @param value Optional, this value specifies the Azure role to be assigned
     */
    @JvmName("iyxrwcvcceydteui")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("jjmggsduektrpamv")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values Optional, this value specifies the Azure role to be assigned
     */
    @JvmName("xsisrxsdrupdfkvf")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value Subscription id for userAssignedIdentity.
     */
    @JvmName("imrnxjyvnnyvylom")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Username created in the database which is mapped to a user in AAD.
     */
    @JvmName("pmdlcgvotadkoxkb")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The authentication type.
     * Expected value is 'userAssignedIdentity'.
     */
    @JvmName("wufmvqerwxeayhmo")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Client Id for userAssignedIdentity.
     */
    @JvmName("joobmhyhatwamddw")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("fyclvmwbyvphievp")
    public suspend fun deleteOrUpdateBehavior(`value`: Either<String, DeleteOrUpdateBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("elxubccolgwstutt")
    public fun deleteOrUpdateBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("rpheoqfmpoldpoyi")
    public fun deleteOrUpdateBehavior(`value`: DeleteOrUpdateBehavior) {
        val toBeMapped = Either.ofRight<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Optional, this value specifies the Azure role to be assigned
     */
    @JvmName("ajpsivfxjanelltt")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values Optional, this value specifies the Azure role to be assigned
     */
    @JvmName("ocgpgtysglbsilie")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value Subscription id for userAssignedIdentity.
     */
    @JvmName("rygevkinwiqdmvtx")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Username created in the database which is mapped to a user in AAD.
     */
    @JvmName("evrvjuehioqcuauc")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserAssignedIdentityAuthInfoArgs = UserAssignedIdentityAuthInfoArgs(
        authType = authType ?: throw PulumiNullFieldException("authType"),
        clientId = clientId,
        deleteOrUpdateBehavior = deleteOrUpdateBehavior,
        roles = roles,
        subscriptionId = subscriptionId,
        userName = userName,
    )
}
