@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The configuration information, used to generate configurations or save to applications
 * @property action Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied to the source application. Default is enable. If optOut, no configuration change will be made on source.
 * @property additionalConfigurations A dictionary of additional configurations to be added. Service will auto generate a set of basic configurations and this property is to full fill more customized configurations
 * @property customizedKeys Optional. A dictionary of default key name and customized key name mapping. If not specified, default key name will be used for generate configurations
 * @property daprProperties Indicates some additional properties for dapr client type
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 */
public data class ConfigurationInfoResponse(
    public val action: String? = null,
    public val additionalConfigurations: Map<String, String>? = null,
    public val customizedKeys: Map<String, String>? = null,
    public val daprProperties: DaprPropertiesResponse? = null,
    public val deleteOrUpdateBehavior: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.ConfigurationInfoResponse):
            ConfigurationInfoResponse = ConfigurationInfoResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            additionalConfigurations = javaType.additionalConfigurations().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            customizedKeys = javaType.customizedKeys().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            daprProperties = javaType.daprProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.DaprPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deleteOrUpdateBehavior = javaType.deleteOrUpdateBehavior().map({ args0 -> args0 }).orElse(null),
        )
    }
}
