@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The service properties when target service type is ConfluentSchemaRegistry
 * @property endpoint The endpoint of service.
 * @property type The target service type.
 * Expected value is 'ConfluentSchemaRegistry'.
 */
public data class ConfluentSchemaRegistryResponse(
    public val endpoint: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.ConfluentSchemaRegistryResponse):
            ConfluentSchemaRegistryResponse = ConfluentSchemaRegistryResponse(
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
