@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Indicates some additional properties for dapr client type
 * @property componentType The dapr component type
 * @property metadata Additional dapr metadata
 * @property scopes The dapr component scopes
 * @property secretStoreComponent The name of a secret store dapr to retrieve secret
 * @property version The dapr component version
 */
public data class DaprPropertiesResponse(
    public val componentType: String? = null,
    public val metadata: List<DaprMetadataResponse>? = null,
    public val scopes: List<String>? = null,
    public val secretStoreComponent: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.DaprPropertiesResponse):
            DaprPropertiesResponse = DaprPropertiesResponse(
            componentType = javaType.componentType().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.DaprMetadataResponse.Companion.toKotlin(args0)
                })
            }),
            scopes = javaType.scopes().map({ args0 -> args0 }),
            secretStoreComponent = javaType.secretStoreComponent().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
