@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The authentication info when authType is userAssignedIdentity
 * @property authType The authentication type.
 * Expected value is 'userAssignedIdentity'.
 * @property clientId Client Id for userAssignedIdentity.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property roles Optional, this value specifies the Azure role to be assigned
 * @property subscriptionId Subscription id for userAssignedIdentity.
 * @property userName Username created in the database which is mapped to a user in AAD.
 */
public data class UserAssignedIdentityAuthInfoResponse(
    public val authType: String,
    public val clientId: String? = null,
    public val deleteOrUpdateBehavior: String? = null,
    public val roles: List<String>? = null,
    public val subscriptionId: String? = null,
    public val userName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.UserAssignedIdentityAuthInfoResponse):
            UserAssignedIdentityAuthInfoResponse = UserAssignedIdentityAuthInfoResponse(
            authType = javaType.authType(),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            deleteOrUpdateBehavior = javaType.deleteOrUpdateBehavior().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles().map({ args0 -> args0 }),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
