@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The VNet solution for linker
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property type Type of VNet solution.
 */
public data class VNetSolutionResponse(
    public val deleteOrUpdateBehavior: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.VNetSolutionResponse):
            VNetSolutionResponse = VNetSolutionResponse(
            deleteOrUpdateBehavior = javaType.deleteOrUpdateBehavior().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
