@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The secret info when type is rawValue. It's for scenarios that user input the secret.
 * @property secretType The secret type.
 * Expected value is 'rawValue'.
 * @property value The actual value of the secret.
 */
public data class ValueSecretInfoResponse(
    public val secretType: String,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.ValueSecretInfoResponse):
            ValueSecretInfoResponse = ValueSecretInfoResponse(
            secretType = javaType.secretType(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
