@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin.inputs

import com.pulumi.azurenative.servicenetworking.inputs.AssociationSubnetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Association Subnet.
 * @property id Association ID.
 */
public data class AssociationSubnetArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicenetworking.inputs.AssociationSubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.servicenetworking.inputs.AssociationSubnetArgs =
        com.pulumi.azurenative.servicenetworking.inputs.AssociationSubnetArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssociationSubnetArgs].
 */
@PulumiTagMarker
public class AssociationSubnetArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Association ID.
     */
    @JvmName("hxsmaowhcdqhugnu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Association ID.
     */
    @JvmName("vxuvddlhkkaswebu")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): AssociationSubnetArgs = AssociationSubnetArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
