@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin.inputs

import com.pulumi.azurenative.servicenetworking.inputs.GetFrontendsInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property frontendName Frontends
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property trafficControllerName traffic controller name for path
 */
public data class GetFrontendsInterfacePlainArgs(
    public val frontendName: String,
    public val resourceGroupName: String,
    public val trafficControllerName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicenetworking.inputs.GetFrontendsInterfacePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicenetworking.inputs.GetFrontendsInterfacePlainArgs =
        com.pulumi.azurenative.servicenetworking.inputs.GetFrontendsInterfacePlainArgs.builder()
            .frontendName(frontendName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .trafficControllerName(trafficControllerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFrontendsInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetFrontendsInterfacePlainArgsBuilder internal constructor() {
    private var frontendName: String? = null

    private var resourceGroupName: String? = null

    private var trafficControllerName: String? = null

    /**
     * @param value Frontends
     */
    @JvmName("mpkgyhflodihqmys")
    public suspend fun frontendName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.frontendName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("voifwflbsxohmgrh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("hojprtjtxndoxvee")
    public suspend fun trafficControllerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trafficControllerName = mapped
    }

    internal fun build(): GetFrontendsInterfacePlainArgs = GetFrontendsInterfacePlainArgs(
        frontendName = frontendName ?: throw PulumiNullFieldException("frontendName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        trafficControllerName = trafficControllerName ?: throw
            PulumiNullFieldException("trafficControllerName"),
    )
}
