@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin

import com.pulumi.azurenative.signalrservice.kotlin.outputs.LiveTraceConfigurationResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ManagedIdentityResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ResourceLogConfigurationResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ResourceSkuResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ServerlessSettingsResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ServerlessUpstreamSettingsResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SharedPrivateLinkResourceResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SignalRCorsSettingsResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SignalRFeatureResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SignalRNetworkACLsResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SignalRTlsSettingsResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.signalrservice.kotlin.outputs.LiveTraceConfigurationResponse.Companion.toKotlin as liveTraceConfigurationResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin as managedIdentityResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ResourceLogConfigurationResponse.Companion.toKotlin as resourceLogConfigurationResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin as resourceSkuResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ServerlessSettingsResponse.Companion.toKotlin as serverlessSettingsResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ServerlessUpstreamSettingsResponse.Companion.toKotlin as serverlessUpstreamSettingsResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SharedPrivateLinkResourceResponse.Companion.toKotlin as sharedPrivateLinkResourceResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SignalRCorsSettingsResponse.Companion.toKotlin as signalRCorsSettingsResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SignalRFeatureResponse.Companion.toKotlin as signalRFeatureResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SignalRNetworkACLsResponse.Companion.toKotlin as signalRNetworkACLsResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SignalRTlsSettingsResponse.Companion.toKotlin as signalRTlsSettingsResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SignalR].
 */
@PulumiTagMarker
public class SignalRResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SignalRArgs = SignalRArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SignalRArgsBuilder.() -> Unit) {
        val builder = SignalRArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SignalR {
        val builtJavaResource = com.pulumi.azurenative.signalrservice.SignalR(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SignalR(builtJavaResource)
    }
}

/**
 * A class represent a resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2018-10-01, 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### SignalR_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var signalR = new AzureNative.SignalRService.SignalR("signalR", new()
 *     {
 *         Cors = new AzureNative.SignalRService.Inputs.SignalRCorsSettingsArgs
 *         {
 *             AllowedOrigins = new[]
 *             {
 *                 "https://foo.com",
 *                 "https://bar.com",
 *             },
 *         },
 *         DisableAadAuth = false,
 *         DisableLocalAuth = false,
 *         Features = new[]
 *         {
 *             new AzureNative.SignalRService.Inputs.SignalRFeatureArgs
 *             {
 *                 Flag = AzureNative.SignalRService.FeatureFlags.ServiceMode,
 *                 Properties = null,
 *                 Value = "Serverless",
 *             },
 *             new AzureNative.SignalRService.Inputs.SignalRFeatureArgs
 *             {
 *                 Flag = AzureNative.SignalRService.FeatureFlags.EnableConnectivityLogs,
 *                 Properties = null,
 *                 Value = "True",
 *             },
 *             new AzureNative.SignalRService.Inputs.SignalRFeatureArgs
 *             {
 *                 Flag = AzureNative.SignalRService.FeatureFlags.EnableMessagingLogs,
 *                 Properties = null,
 *                 Value = "False",
 *             },
 *             new AzureNative.SignalRService.Inputs.SignalRFeatureArgs
 *             {
 *                 Flag = AzureNative.SignalRService.FeatureFlags.EnableLiveTrace,
 *                 Properties = null,
 *                 Value = "False",
 *             },
 *         },
 *         Identity = new AzureNative.SignalRService.Inputs.ManagedIdentityArgs
 *         {
 *             Type = AzureNative.SignalRService.ManagedIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.SignalRService.ServiceKind.SignalR,
 *         LiveTraceConfiguration = new AzureNative.SignalRService.Inputs.LiveTraceConfigurationArgs
 *         {
 *             Categories = new[]
 *             {
 *                 new AzureNative.SignalRService.Inputs.LiveTraceCategoryArgs
 *                 {
 *                     Enabled = "true",
 *                     Name = "ConnectivityLogs",
 *                 },
 *             },
 *             Enabled = "false",
 *         },
 *         Location = "eastus",
 *         NetworkACLs = new AzureNative.SignalRService.Inputs.SignalRNetworkACLsArgs
 *         {
 *             DefaultAction = AzureNative.SignalRService.ACLAction.Deny,
 *             PrivateEndpoints = new[]
 *             {
 *                 new AzureNative.SignalRService.Inputs.PrivateEndpointACLArgs
 *                 {
 *                     Allow = new[]
 *                     {
 *                         AzureNative.SignalRService.SignalRRequestType.ServerConnection,
 *                     },
 *                     Name = "mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e",
 *                 },
 *             },
 *             PublicNetwork = new AzureNative.SignalRService.Inputs.NetworkACLArgs
 *             {
 *                 Allow = new[]
 *                 {
 *                     AzureNative.SignalRService.SignalRRequestType.ClientConnection,
 *                 },
 *             },
 *         },
 *         PublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "mySignalRService",
 *         Serverless = new AzureNative.SignalRService.Inputs.ServerlessSettingsArgs
 *         {
 *             ConnectionTimeoutInSeconds = 5,
 *         },
 *         Sku = new AzureNative.SignalRService.Inputs.ResourceSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium_P1",
 *             Tier = AzureNative.SignalRService.SignalRSkuTier.Premium,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         Tls = new AzureNative.SignalRService.Inputs.SignalRTlsSettingsArgs
 *         {
 *             ClientCertEnabled = false,
 *         },
 *         Upstream = new AzureNative.SignalRService.Inputs.ServerlessUpstreamSettingsArgs
 *         {
 *             Templates = new[]
 *             {
 *                 new AzureNative.SignalRService.Inputs.UpstreamTemplateArgs
 *                 {
 *                     Auth = new AzureNative.SignalRService.Inputs.UpstreamAuthSettingsArgs
 *                     {
 *                         ManagedIdentity = new AzureNative.SignalRService.Inputs.ManagedIdentitySettingsArgs
 *                         {
 *                             Resource = "api://example",
 *                         },
 *                         Type = AzureNative.SignalRService.UpstreamAuthType.ManagedIdentity,
 *                     },
 *                     CategoryPattern = "*",
 *                     EventPattern = "connect,disconnect",
 *                     HubPattern = "*",
 *                     UrlTemplate = "https://example.com/chat/api/connect",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/signalrservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := signalrservice.NewSignalR(ctx, "signalR", &signalrservice.SignalRArgs{
 * 			Cors: &signalrservice.SignalRCorsSettingsArgs{
 * 				AllowedOrigins: pulumi.StringArray{
 * 					pulumi.String("https://foo.com"),
 * 					pulumi.String("https://bar.com"),
 * 				},
 * 			},
 * 			DisableAadAuth:   pulumi.Bool(false),
 * 			DisableLocalAuth: pulumi.Bool(false),
 * 			Features: signalrservice.SignalRFeatureArray{
 * 				&signalrservice.SignalRFeatureArgs{
 * 					Flag:       pulumi.String(signalrservice.FeatureFlagsServiceMode),
 * 					Properties: nil,
 * 					Value:      pulumi.String("Serverless"),
 * 				},
 * 				&signalrservice.SignalRFeatureArgs{
 * 					Flag:       pulumi.String(signalrservice.FeatureFlagsEnableConnectivityLogs),
 * 					Properties: nil,
 * 					Value:      pulumi.String("True"),
 * 				},
 * 				&signalrservice.SignalRFeatureArgs{
 * 					Flag:       pulumi.String(signalrservice.FeatureFlagsEnableMessagingLogs),
 * 					Properties: nil,
 * 					Value:      pulumi.String("False"),
 * 				},
 * 				&signalrservice.SignalRFeatureArgs{
 * 					Flag:       pulumi.String(signalrservice.FeatureFlagsEnableLiveTrace),
 * 					Properties: nil,
 * 					Value:      pulumi.String("False"),
 * 				},
 * 			},
 * 			Identity: &signalrservice.ManagedIdentityArgs{
 * 				Type: pulumi.String(signalrservice.ManagedIdentityTypeSystemAssigned),
 * 			},
 * 			Kind: pulumi.String(signalrservice.ServiceKindSignalR),
 * 			LiveTraceConfiguration: &signalrservice.LiveTraceConfigurationArgs{
 * 				Categories: signalrservice.LiveTraceCategoryArray{
 * 					&signalrservice.LiveTraceCategoryArgs{
 * 						Enabled: pulumi.String("true"),
 * 						Name:    pulumi.String("ConnectivityLogs"),
 * 					},
 * 				},
 * 				Enabled: pulumi.String("false"),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			NetworkACLs: &signalrservice.SignalRNetworkACLsArgs{
 * 				DefaultAction: pulumi.String(signalrservice.ACLActionDeny),
 * 				PrivateEndpoints: signalrservice.PrivateEndpointACLArray{
 * 					&signalrservice.PrivateEndpointACLArgs{
 * 						Allow: pulumi.StringArray{
 * 							pulumi.String(signalrservice.SignalRRequestTypeServerConnection),
 * 						},
 * 						Name: pulumi.String("mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e"),
 * 					},
 * 				},
 * 				PublicNetwork: &signalrservice.NetworkACLArgs{
 * 					Allow: pulumi.StringArray{
 * 						pulumi.String(signalrservice.SignalRRequestTypeClientConnection),
 * 					},
 * 				},
 * 			},
 * 			PublicNetworkAccess: pulumi.String("Enabled"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ResourceName:        pulumi.String("mySignalRService"),
 * 			Serverless: &signalrservice.ServerlessSettingsArgs{
 * 				ConnectionTimeoutInSeconds: pulumi.Int(5),
 * 			},
 * 			Sku: &signalrservice.ResourceSkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Premium_P1"),
 * 				Tier:     pulumi.String(signalrservice.SignalRSkuTierPremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			Tls: &signalrservice.SignalRTlsSettingsArgs{
 * 				ClientCertEnabled: pulumi.Bool(false),
 * 			},
 * 			Upstream: &signalrservice.ServerlessUpstreamSettingsArgs{
 * 				Templates: signalrservice.UpstreamTemplateArray{
 * 					&signalrservice.UpstreamTemplateArgs{
 * 						Auth: &signalrservice.UpstreamAuthSettingsArgs{
 * 							ManagedIdentity: &signalrservice.ManagedIdentitySettingsArgs{
 * 								Resource: pulumi.String("api://example"),
 * 							},
 * 							Type: pulumi.String(signalrservice.UpstreamAuthTypeManagedIdentity),
 * 						},
 * 						CategoryPattern: pulumi.String("*"),
 * 						EventPattern:    pulumi.String("connect,disconnect"),
 * 						HubPattern:      pulumi.String("*"),
 * 						UrlTemplate:     pulumi.String("https://example.com/chat/api/connect"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.signalrservice.SignalR;
 * import com.pulumi.azurenative.signalrservice.SignalRArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.SignalRCorsSettingsArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.SignalRFeatureArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.ManagedIdentityArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.LiveTraceConfigurationArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.SignalRNetworkACLsArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.NetworkACLArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.ServerlessSettingsArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.ResourceSkuArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.SignalRTlsSettingsArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.ServerlessUpstreamSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var signalR = new SignalR("signalR", SignalRArgs.builder()
 *             .cors(SignalRCorsSettingsArgs.builder()
 *                 .allowedOrigins(
 *                     "https://foo.com",
 *                     "https://bar.com")
 *                 .build())
 *             .disableAadAuth(false)
 *             .disableLocalAuth(false)
 *             .features(
 *                 SignalRFeatureArgs.builder()
 *                     .flag("ServiceMode")
 *                     .properties()
 *                     .value("Serverless")
 *                     .build(),
 *                 SignalRFeatureArgs.builder()
 *                     .flag("EnableConnectivityLogs")
 *                     .properties()
 *                     .value("True")
 *                     .build(),
 *                 SignalRFeatureArgs.builder()
 *                     .flag("EnableMessagingLogs")
 *                     .properties()
 *                     .value("False")
 *                     .build(),
 *                 SignalRFeatureArgs.builder()
 *                     .flag("EnableLiveTrace")
 *                     .properties()
 *                     .value("False")
 *                     .build())
 *             .identity(ManagedIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("SignalR")
 *             .liveTraceConfiguration(LiveTraceConfigurationArgs.builder()
 *                 .categories(LiveTraceCategoryArgs.builder()
 *                     .enabled("true")
 *                     .name("ConnectivityLogs")
 *                     .build())
 *                 .enabled("false")
 *                 .build())
 *             .location("eastus")
 *             .networkACLs(SignalRNetworkACLsArgs.builder()
 *                 .defaultAction("Deny")
 *                 .privateEndpoints(PrivateEndpointACLArgs.builder()
 *                     .allow("ServerConnection")
 *                     .name("mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e")
 *                     .build())
 *                 .publicNetwork(NetworkACLArgs.builder()
 *                     .allow("ClientConnection")
 *                     .build())
 *                 .build())
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("mySignalRService")
 *             .serverless(ServerlessSettingsArgs.builder()
 *                 .connectionTimeoutInSeconds(5)
 *                 .build())
 *             .sku(ResourceSkuArgs.builder()
 *                 .capacity(1)
 *                 .name("Premium_P1")
 *                 .tier("Premium")
 *                 .build())
 *             .tags(Map.of("key1", "value1"))
 *             .tls(SignalRTlsSettingsArgs.builder()
 *                 .clientCertEnabled(false)
 *                 .build())
 *             .upstream(ServerlessUpstreamSettingsArgs.builder()
 *                 .templates(UpstreamTemplateArgs.builder()
 *                     .auth(UpstreamAuthSettingsArgs.builder()
 *                         .managedIdentity(ManagedIdentitySettingsArgs.builder()
 *                             .resource("api://example")
 *                             .build())
 *                         .type("ManagedIdentity")
 *                         .build())
 *                     .categoryPattern("*")
 *                     .eventPattern("connect,disconnect")
 *                     .hubPattern("*")
 *                     .urlTemplate("https://example.com/chat/api/connect")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:signalrservice:SignalR mySignalRService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/signalR/{resourceName}
 * ```
 */
public class SignalR internal constructor(
    override val javaResource: com.pulumi.azurenative.signalrservice.SignalR,
) : KotlinCustomResource(javaResource, SignalRMapper) {
    /**
     * Cross-Origin Resource Sharing (CORS) settings.
     */
    public val cors: Output<SignalRCorsSettingsResponse>?
        get() = javaResource.cors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    signalRCorsSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * DisableLocalAuth
     * Enable or disable aad auth
     * When set as true, connection with AuthType=aad won't work.
     */
    public val disableAadAuth: Output<Boolean>?
        get() = javaResource.disableAadAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DisableLocalAuth
     * Enable or disable local auth with AccessKey
     * When set as true, connection with AccessKey=xxx won't work.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The publicly accessible IP of the resource.
     */
    public val externalIP: Output<String>
        get() = javaResource.externalIP().applyValue({ args0 -> args0 })

    /**
     * List of the featureFlags.
     * FeatureFlags that are not included in the parameters for the update operation will not be modified.
     * And the response will only include featureFlags that are explicitly set.
     * When a featureFlag is not explicitly set, its globally default value will be used
     * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
     */
    public val features: Output<List<SignalRFeatureResponse>>?
        get() = javaResource.features().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> signalRFeatureResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * FQDN of the service instance.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * Deprecated.
     */
    public val hostNamePrefix: Output<String>
        get() = javaResource.hostNamePrefix().applyValue({ args0 -> args0 })

    /**
     * A class represent managed identities used for request and response
     */
    public val identity: Output<ManagedIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of the service, it can be SignalR or RawWebSockets
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Live trace configuration of a Microsoft.SignalRService resource.
     */
    public val liveTraceConfiguration: Output<LiveTraceConfigurationResponse>?
        get() = javaResource.liveTraceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> liveTraceConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network ACLs for the resource
     */
    public val networkACLs: Output<SignalRNetworkACLsResponse>?
        get() = javaResource.networkACLs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    signalRNetworkACLsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Private endpoint connections to the resource.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Enable or disable public network access. Default to "Enabled".
     * When it's Enabled, network ACLs still apply.
     * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The publicly accessible port of the resource which is designed for browser/client side usage.
     */
    public val publicPort: Output<Int>
        get() = javaResource.publicPort().applyValue({ args0 -> args0 })

    /**
     * Resource log configuration of a Microsoft.SignalRService resource.
     */
    public val resourceLogConfiguration: Output<ResourceLogConfigurationResponse>?
        get() = javaResource.resourceLogConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceLogConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The publicly accessible port of the resource which is designed for customer server side usage.
     */
    public val serverPort: Output<Int>
        get() = javaResource.serverPort().applyValue({ args0 -> args0 })

    /**
     * Serverless settings.
     */
    public val serverless: Output<ServerlessSettingsResponse>?
        get() = javaResource.serverless().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverlessSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The list of shared private link resources.
     */
    public val sharedPrivateLinkResources: Output<List<SharedPrivateLinkResourceResponse>>
        get() = javaResource.sharedPrivateLinkResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sharedPrivateLinkResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The billing information of the resource.
     */
    public val sku: Output<ResourceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags of the service which is a list of key value pairs that describe the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * TLS settings for the resource
     */
    public val tls: Output<SignalRTlsSettingsResponse>?
        get() = javaResource.tls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    signalRTlsSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The settings for the Upstream when the service is in server-less mode.
     */
    public val upstream: Output<ServerlessUpstreamSettingsResponse>?
        get() = javaResource.upstream().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverlessUpstreamSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Version of the resource. Probably you need the same or higher version of client SDKs.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object SignalRMapper : ResourceMapper<SignalR> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.signalrservice.SignalR::class == javaResource::class

    override fun map(javaResource: Resource): SignalR = SignalR(
        javaResource as
            com.pulumi.azurenative.signalrservice.SignalR,
    )
}

/**
 * @see [SignalR].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SignalR].
 */
public suspend fun signalR(name: String, block: suspend SignalRResourceBuilder.() -> Unit):
    SignalR {
    val builder = SignalRResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SignalR].
 * @param name The _unique_ name of the resulting resource.
 */
public fun signalR(name: String): SignalR {
    val builder = SignalRResourceBuilder()
    builder.name(name)
    return builder.build()
}
