@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin

import com.pulumi.azurenative.signalrservice.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SignalRCustomDomain].
 */
@PulumiTagMarker
public class SignalRCustomDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SignalRCustomDomainArgs = SignalRCustomDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SignalRCustomDomainArgsBuilder.() -> Unit) {
        val builder = SignalRCustomDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SignalRCustomDomain {
        val builtJavaResource =
            com.pulumi.azurenative.signalrservice.SignalRCustomDomain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SignalRCustomDomain(builtJavaResource)
    }
}

/**
 * A custom domain
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### SignalRCustomDomains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var signalRCustomDomain = new AzureNative.SignalRService.SignalRCustomDomain("signalRCustomDomain", new()
 *     {
 *         CustomCertificate = new AzureNative.SignalRService.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/SignalR/mySignalRService/customCertificates/myCert",
 *         },
 *         DomainName = "example.com",
 *         Name = "myDomain",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "mySignalRService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/signalrservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := signalrservice.NewSignalRCustomDomain(ctx, "signalRCustomDomain", &signalrservice.SignalRCustomDomainArgs{
 * 			CustomCertificate: &signalrservice.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/SignalR/mySignalRService/customCertificates/myCert"),
 * 			},
 * 			DomainName:        pulumi.String("example.com"),
 * 			Name:              pulumi.String("myDomain"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("mySignalRService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.signalrservice.SignalRCustomDomain;
 * import com.pulumi.azurenative.signalrservice.SignalRCustomDomainArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.ResourceReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var signalRCustomDomain = new SignalRCustomDomain("signalRCustomDomain", SignalRCustomDomainArgs.builder()
 *             .customCertificate(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/SignalR/mySignalRService/customCertificates/myCert")
 *                 .build())
 *             .domainName("example.com")
 *             .name("myDomain")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("mySignalRService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:signalrservice:SignalRCustomDomain myDomain /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/signalR/{resourceName}/customDomains/{name}
 * ```
 */
public class SignalRCustomDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.signalrservice.SignalRCustomDomain,
) : KotlinCustomResource(javaResource, SignalRCustomDomainMapper) {
    /**
     * Reference to a resource.
     */
    public val customCertificate: Output<ResourceReferenceResponse>
        get() = javaResource.customCertificate().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceReferenceResponseToKotlin(args0)
            })
        })

    /**
     * The custom domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SignalRCustomDomainMapper : ResourceMapper<SignalRCustomDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.signalrservice.SignalRCustomDomain::class == javaResource::class

    override fun map(javaResource: Resource): SignalRCustomDomain = SignalRCustomDomain(
        javaResource
            as com.pulumi.azurenative.signalrservice.SignalRCustomDomain,
    )
}

/**
 * @see [SignalRCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SignalRCustomDomain].
 */
public suspend fun signalRCustomDomain(
    name: String,
    block: suspend SignalRCustomDomainResourceBuilder.() -> Unit,
): SignalRCustomDomain {
    val builder = SignalRCustomDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SignalRCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun signalRCustomDomain(name: String): SignalRCustomDomain {
    val builder = SignalRCustomDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
