@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin

import com.pulumi.azurenative.signalrservice.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.signalrservice.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SignalRPrivateEndpointConnection].
 */
@PulumiTagMarker
public class SignalRPrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SignalRPrivateEndpointConnectionArgs = SignalRPrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SignalRPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = SignalRPrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SignalRPrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.signalrservice.SignalRPrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SignalRPrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * A private endpoint connection to an azure resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### SignalRPrivateEndpointConnections_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var signalRPrivateEndpointConnection = new AzureNative.SignalRService.SignalRPrivateEndpointConnection("signalRPrivateEndpointConnection", new()
 *     {
 *         PrivateEndpoint = new AzureNative.SignalRService.Inputs.PrivateEndpointArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint",
 *         },
 *         PrivateEndpointConnectionName = "mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e",
 *         PrivateLinkServiceConnectionState = new AzureNative.SignalRService.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Status = AzureNative.SignalRService.PrivateLinkServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "mySignalRService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/signalrservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := signalrservice.NewSignalRPrivateEndpointConnection(ctx, "signalRPrivateEndpointConnection", &signalrservice.SignalRPrivateEndpointConnectionArgs{
 * 			PrivateEndpoint: &signalrservice.PrivateEndpointArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
 * 			},
 * 			PrivateEndpointConnectionName: pulumi.String("mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e"),
 * 			PrivateLinkServiceConnectionState: &signalrservice.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Status:          pulumi.String(signalrservice.PrivateLinkServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("mySignalRService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.signalrservice.SignalRPrivateEndpointConnection;
 * import com.pulumi.azurenative.signalrservice.SignalRPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointArgs;
 * import com.pulumi.azurenative.signalrservice.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var signalRPrivateEndpointConnection = new SignalRPrivateEndpointConnection("signalRPrivateEndpointConnection", SignalRPrivateEndpointConnectionArgs.builder()
 *             .privateEndpoint(PrivateEndpointArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint")
 *                 .build())
 *             .privateEndpointConnectionName("mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .actionsRequired("None")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("mySignalRService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:signalrservice:SignalRPrivateEndpointConnection mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/signalR/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class SignalRPrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.signalrservice.SignalRPrivateEndpointConnection,
) : KotlinCustomResource(javaResource, SignalRPrivateEndpointConnectionMapper) {
    /**
     * Group IDs
     */
    public val groupIds: Output<List<String>>
        get() = javaResource.groupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Private endpoint
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Connection state of the private endpoint connection
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServiceConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SignalRPrivateEndpointConnectionMapper :
    ResourceMapper<SignalRPrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.signalrservice.SignalRPrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): SignalRPrivateEndpointConnection =
        SignalRPrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.signalrservice.SignalRPrivateEndpointConnection,
        )
}

/**
 * @see [SignalRPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SignalRPrivateEndpointConnection].
 */
public suspend fun signalRPrivateEndpointConnection(
    name: String,
    block: suspend SignalRPrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    SignalRPrivateEndpointConnection {
    val builder = SignalRPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SignalRPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun signalRPrivateEndpointConnection(name: String): SignalRPrivateEndpointConnection {
    val builder = SignalRPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
