@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin

import com.pulumi.azurenative.signalrservice.SignalrserviceFunctions.getSignalRCustomCertificatePlain
import com.pulumi.azurenative.signalrservice.SignalrserviceFunctions.getSignalRCustomDomainPlain
import com.pulumi.azurenative.signalrservice.SignalrserviceFunctions.getSignalRPlain
import com.pulumi.azurenative.signalrservice.SignalrserviceFunctions.getSignalRPrivateEndpointConnectionPlain
import com.pulumi.azurenative.signalrservice.SignalrserviceFunctions.getSignalRReplicaPlain
import com.pulumi.azurenative.signalrservice.SignalrserviceFunctions.getSignalRSharedPrivateLinkResourcePlain
import com.pulumi.azurenative.signalrservice.SignalrserviceFunctions.listSignalRKeysPlain
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRCustomCertificatePlainArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRCustomCertificatePlainArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRCustomDomainPlainArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRCustomDomainPlainArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRPlainArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRPlainArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRReplicaPlainArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRReplicaPlainArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRSharedPrivateLinkResourcePlainArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.GetSignalRSharedPrivateLinkResourcePlainArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ListSignalRKeysPlainArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ListSignalRKeysPlainArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRCustomCertificateResult
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRCustomDomainResult
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRPrivateEndpointConnectionResult
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRReplicaResult
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRResult
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRSharedPrivateLinkResourceResult
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ListSignalRKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRCustomCertificateResult.Companion.toKotlin as getSignalRCustomCertificateResultToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRCustomDomainResult.Companion.toKotlin as getSignalRCustomDomainResultToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRPrivateEndpointConnectionResult.Companion.toKotlin as getSignalRPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRReplicaResult.Companion.toKotlin as getSignalRReplicaResultToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRResult.Companion.toKotlin as getSignalRResultToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.GetSignalRSharedPrivateLinkResourceResult.Companion.toKotlin as getSignalRSharedPrivateLinkResourceResultToKotlin
import com.pulumi.azurenative.signalrservice.kotlin.outputs.ListSignalRKeysResult.Companion.toKotlin as listSignalRKeysResultToKotlin

public object SignalrserviceFunctions {
    /**
     * Get the resource and its properties.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2018-10-01, 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return A class represent a resource.
     */
    public suspend fun getSignalR(argument: GetSignalRPlainArgs): GetSignalRResult =
        getSignalRResultToKotlin(getSignalRPlain(argument.toJava()).await())

    /**
     * @see [getSignalR].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param resourceName The name of the resource.
     * @return A class represent a resource.
     */
    public suspend fun getSignalR(resourceGroupName: String, resourceName: String): GetSignalRResult {
        val argument = GetSignalRPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSignalRResultToKotlin(getSignalRPlain(argument.toJava()).await())
    }

    /**
     * @see [getSignalR].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;signalrservice&#46;kotlin&#46;inputs&#46;GetSignalRPlainArgs].
     * @return A class represent a resource.
     */
    public suspend fun getSignalR(argument: suspend GetSignalRPlainArgsBuilder.() -> Unit):
        GetSignalRResult {
        val builder = GetSignalRPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSignalRResultToKotlin(getSignalRPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a custom certificate.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return A custom certificate.
     */
    public suspend fun getSignalRCustomCertificate(argument: GetSignalRCustomCertificatePlainArgs):
        GetSignalRCustomCertificateResult =
        getSignalRCustomCertificateResultToKotlin(getSignalRCustomCertificatePlain(argument.toJava()).await())

    /**
     * @see [getSignalRCustomCertificate].
     * @param certificateName Custom certificate name
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param resourceName The name of the resource.
     * @return A custom certificate.
     */
    public suspend fun getSignalRCustomCertificate(
        certificateName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetSignalRCustomCertificateResult {
        val argument = GetSignalRCustomCertificatePlainArgs(
            certificateName = certificateName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSignalRCustomCertificateResultToKotlin(getSignalRCustomCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getSignalRCustomCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;signalrservice&#46;kotlin&#46;inputs&#46;GetSignalRCustomCertificatePlainArgs].
     * @return A custom certificate.
     */
    public suspend
    fun getSignalRCustomCertificate(argument: suspend GetSignalRCustomCertificatePlainArgsBuilder.() -> Unit):
        GetSignalRCustomCertificateResult {
        val builder = GetSignalRCustomCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSignalRCustomCertificateResultToKotlin(getSignalRCustomCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a custom domain.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return A custom domain
     */
    public suspend fun getSignalRCustomDomain(argument: GetSignalRCustomDomainPlainArgs):
        GetSignalRCustomDomainResult =
        getSignalRCustomDomainResultToKotlin(getSignalRCustomDomainPlain(argument.toJava()).await())

    /**
     * @see [getSignalRCustomDomain].
     * @param name Custom domain name.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param resourceName The name of the resource.
     * @return A custom domain
     */
    public suspend fun getSignalRCustomDomain(
        name: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetSignalRCustomDomainResult {
        val argument = GetSignalRCustomDomainPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSignalRCustomDomainResultToKotlin(getSignalRCustomDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getSignalRCustomDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;signalrservice&#46;kotlin&#46;inputs&#46;GetSignalRCustomDomainPlainArgs].
     * @return A custom domain
     */
    public suspend
    fun getSignalRCustomDomain(argument: suspend GetSignalRCustomDomainPlainArgsBuilder.() -> Unit):
        GetSignalRCustomDomainResult {
        val builder = GetSignalRCustomDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSignalRCustomDomainResultToKotlin(getSignalRCustomDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the specified private endpoint connection
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return A private endpoint connection to an azure resource
     */
    public suspend
    fun getSignalRPrivateEndpointConnection(argument: GetSignalRPrivateEndpointConnectionPlainArgs):
        GetSignalRPrivateEndpointConnectionResult =
        getSignalRPrivateEndpointConnectionResultToKotlin(getSignalRPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getSignalRPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param resourceName The name of the resource.
     * @return A private endpoint connection to an azure resource
     */
    public suspend fun getSignalRPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetSignalRPrivateEndpointConnectionResult {
        val argument = GetSignalRPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSignalRPrivateEndpointConnectionResultToKotlin(getSignalRPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSignalRPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;signalrservice&#46;kotlin&#46;inputs&#46;GetSignalRPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection to an azure resource
     */
    public suspend
    fun getSignalRPrivateEndpointConnection(argument: suspend GetSignalRPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetSignalRPrivateEndpointConnectionResult {
        val builder = GetSignalRPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSignalRPrivateEndpointConnectionResultToKotlin(getSignalRPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the replica and its properties.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return A class represent a replica resource.
     */
    public suspend fun getSignalRReplica(argument: GetSignalRReplicaPlainArgs):
        GetSignalRReplicaResult =
        getSignalRReplicaResultToKotlin(getSignalRReplicaPlain(argument.toJava()).await())

    /**
     * @see [getSignalRReplica].
     * @param replicaName The name of the replica.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the resource.
     * @return A class represent a replica resource.
     */
    public suspend fun getSignalRReplica(
        replicaName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetSignalRReplicaResult {
        val argument = GetSignalRReplicaPlainArgs(
            replicaName = replicaName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSignalRReplicaResultToKotlin(getSignalRReplicaPlain(argument.toJava()).await())
    }

    /**
     * @see [getSignalRReplica].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;signalrservice&#46;kotlin&#46;inputs&#46;GetSignalRReplicaPlainArgs].
     * @return A class represent a replica resource.
     */
    public suspend
    fun getSignalRReplica(argument: suspend GetSignalRReplicaPlainArgsBuilder.() -> Unit):
        GetSignalRReplicaResult {
        val builder = GetSignalRReplicaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSignalRReplicaResultToKotlin(getSignalRReplicaPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the specified shared private link resource
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return Describes a Shared Private Link Resource
     */
    public suspend
    fun getSignalRSharedPrivateLinkResource(argument: GetSignalRSharedPrivateLinkResourcePlainArgs):
        GetSignalRSharedPrivateLinkResourceResult =
        getSignalRSharedPrivateLinkResourceResultToKotlin(getSignalRSharedPrivateLinkResourcePlain(argument.toJava()).await())

    /**
     * @see [getSignalRSharedPrivateLinkResource].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param resourceName The name of the resource.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource
     * @return Describes a Shared Private Link Resource
     */
    public suspend fun getSignalRSharedPrivateLinkResource(
        resourceGroupName: String,
        resourceName: String,
        sharedPrivateLinkResourceName: String,
    ): GetSignalRSharedPrivateLinkResourceResult {
        val argument = GetSignalRSharedPrivateLinkResourcePlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            sharedPrivateLinkResourceName = sharedPrivateLinkResourceName,
        )
        return getSignalRSharedPrivateLinkResourceResultToKotlin(getSignalRSharedPrivateLinkResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getSignalRSharedPrivateLinkResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;signalrservice&#46;kotlin&#46;inputs&#46;GetSignalRSharedPrivateLinkResourcePlainArgs].
     * @return Describes a Shared Private Link Resource
     */
    public suspend
    fun getSignalRSharedPrivateLinkResource(argument: suspend GetSignalRSharedPrivateLinkResourcePlainArgsBuilder.() -> Unit):
        GetSignalRSharedPrivateLinkResourceResult {
        val builder = GetSignalRSharedPrivateLinkResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSignalRSharedPrivateLinkResourceResultToKotlin(getSignalRSharedPrivateLinkResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the access keys of the resource.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2018-10-01, 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return A class represents the access keys of the resource.
     */
    public suspend fun listSignalRKeys(argument: ListSignalRKeysPlainArgs): ListSignalRKeysResult =
        listSignalRKeysResultToKotlin(listSignalRKeysPlain(argument.toJava()).await())

    /**
     * @see [listSignalRKeys].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param resourceName The name of the resource.
     * @return A class represents the access keys of the resource.
     */
    public suspend fun listSignalRKeys(resourceGroupName: String, resourceName: String):
        ListSignalRKeysResult {
        val argument = ListSignalRKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listSignalRKeysResultToKotlin(listSignalRKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listSignalRKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;signalrservice&#46;kotlin&#46;inputs&#46;ListSignalRKeysPlainArgs].
     * @return A class represents the access keys of the resource.
     */
    public suspend fun listSignalRKeys(argument: suspend ListSignalRKeysPlainArgsBuilder.() -> Unit):
        ListSignalRKeysResult {
        val builder = ListSignalRKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSignalRKeysResultToKotlin(listSignalRKeysPlain(builtArgument.toJava()).await())
    }
}
