@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * FeatureFlags is the supported features of Azure SignalR service.
 * - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
 * - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
 * - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
 * - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
 */
public enum class FeatureFlags(
    public val javaValue: com.pulumi.azurenative.signalrservice.enums.FeatureFlags,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.enums.FeatureFlags> {
    ServiceMode(com.pulumi.azurenative.signalrservice.enums.FeatureFlags.ServiceMode),
    EnableConnectivityLogs(com.pulumi.azurenative.signalrservice.enums.FeatureFlags.EnableConnectivityLogs),
    EnableMessagingLogs(com.pulumi.azurenative.signalrservice.enums.FeatureFlags.EnableMessagingLogs),
    EnableLiveTrace(com.pulumi.azurenative.signalrservice.enums.FeatureFlags.EnableLiveTrace),
    ;

    override fun toJava(): com.pulumi.azurenative.signalrservice.enums.FeatureFlags = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.enums.FeatureFlags):
            FeatureFlags = FeatureFlags.values().first { it.javaValue == javaType }
    }
}
