@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.UpstreamTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Upstream template item settings. It defines the Upstream URL of the incoming requests.
 * The template defines the pattern of the event, the hub or the category of the incoming request that matches current URL template.
 * @property auth Upstream auth settings. If not set, no auth is used for upstream messages.
 * @property categoryPattern Gets or sets the matching pattern for category names. If not set, it matches any category.
 * There are 3 kind of patterns supported:
 *     1. "*", it to matches any category name.
 *     2. Combine multiple categories with ",", for example "connections,messages", it matches category "connections" and "messages".
 *     3. The single category name, for example, "connections", it matches the category "connections".
 * @property eventPattern Gets or sets the matching pattern for event names. If not set, it matches any event.
 * There are 3 kind of patterns supported:
 *     1. "*", it to matches any event name.
 *     2. Combine multiple events with ",", for example "connect,disconnect", it matches event "connect" and "disconnect".
 *     3. The single event name, for example, "connect", it matches "connect".
 * @property hubPattern Gets or sets the matching pattern for hub names. If not set, it matches any hub.
 * There are 3 kind of patterns supported:
 *     1. "*", it to matches any hub name.
 *     2. Combine multiple hubs with ",", for example "hub1,hub2", it matches "hub1" and "hub2".
 *     3. The single hub name, for example, "hub1", it matches "hub1".
 * @property urlTemplate Gets or sets the Upstream URL template. You can use 3 predefined parameters {hub}, {category} {event} inside the template, the value of the Upstream URL is dynamically calculated when the client request comes in.
 * For example, if the urlTemplate is `http://example.com/{hub}/api/{event}`, with a client request from hub `chat` connects, it will first POST to this URL: `http://example.com/chat/api/connect`.
 */
public data class UpstreamTemplateArgs(
    public val auth: Output<UpstreamAuthSettingsArgs>? = null,
    public val categoryPattern: Output<String>? = null,
    public val eventPattern: Output<String>? = null,
    public val hubPattern: Output<String>? = null,
    public val urlTemplate: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.UpstreamTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.UpstreamTemplateArgs =
        com.pulumi.azurenative.signalrservice.inputs.UpstreamTemplateArgs.builder()
            .auth(auth?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .categoryPattern(categoryPattern?.applyValue({ args0 -> args0 }))
            .eventPattern(eventPattern?.applyValue({ args0 -> args0 }))
            .hubPattern(hubPattern?.applyValue({ args0 -> args0 }))
            .urlTemplate(urlTemplate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UpstreamTemplateArgs].
 */
@PulumiTagMarker
public class UpstreamTemplateArgsBuilder internal constructor() {
    private var auth: Output<UpstreamAuthSettingsArgs>? = null

    private var categoryPattern: Output<String>? = null

    private var eventPattern: Output<String>? = null

    private var hubPattern: Output<String>? = null

    private var urlTemplate: Output<String>? = null

    /**
     * @param value Upstream auth settings. If not set, no auth is used for upstream messages.
     */
    @JvmName("tpycibkmirbwayus")
    public suspend fun auth(`value`: Output<UpstreamAuthSettingsArgs>) {
        this.auth = value
    }

    /**
     * @param value Gets or sets the matching pattern for category names. If not set, it matches any category.
     * There are 3 kind of patterns supported:
     *     1. "*", it to matches any category name.
     *     2. Combine multiple categories with ",", for example "connections,messages", it matches category "connections" and "messages".
     *     3. The single category name, for example, "connections", it matches the category "connections".
     */
    @JvmName("utaxcgtnexlshgtv")
    public suspend fun categoryPattern(`value`: Output<String>) {
        this.categoryPattern = value
    }

    /**
     * @param value Gets or sets the matching pattern for event names. If not set, it matches any event.
     * There are 3 kind of patterns supported:
     *     1. "*", it to matches any event name.
     *     2. Combine multiple events with ",", for example "connect,disconnect", it matches event "connect" and "disconnect".
     *     3. The single event name, for example, "connect", it matches "connect".
     */
    @JvmName("apxkiosmvaaxkpsx")
    public suspend fun eventPattern(`value`: Output<String>) {
        this.eventPattern = value
    }

    /**
     * @param value Gets or sets the matching pattern for hub names. If not set, it matches any hub.
     * There are 3 kind of patterns supported:
     *     1. "*", it to matches any hub name.
     *     2. Combine multiple hubs with ",", for example "hub1,hub2", it matches "hub1" and "hub2".
     *     3. The single hub name, for example, "hub1", it matches "hub1".
     */
    @JvmName("hbhcdjbfcissfcvw")
    public suspend fun hubPattern(`value`: Output<String>) {
        this.hubPattern = value
    }

    /**
     * @param value Gets or sets the Upstream URL template. You can use 3 predefined parameters {hub}, {category} {event} inside the template, the value of the Upstream URL is dynamically calculated when the client request comes in.
     * For example, if the urlTemplate is `http://example.com/{hub}/api/{event}`, with a client request from hub `chat` connects, it will first POST to this URL: `http://example.com/chat/api/connect`.
     */
    @JvmName("hublktotdvdtibdb")
    public suspend fun urlTemplate(`value`: Output<String>) {
        this.urlTemplate = value
    }

    /**
     * @param value Upstream auth settings. If not set, no auth is used for upstream messages.
     */
    @JvmName("gsmhiadjirxrihvu")
    public suspend fun auth(`value`: UpstreamAuthSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param argument Upstream auth settings. If not set, no auth is used for upstream messages.
     */
    @JvmName("peeioxdfuefywbqs")
    public suspend fun auth(argument: suspend UpstreamAuthSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UpstreamAuthSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param value Gets or sets the matching pattern for category names. If not set, it matches any category.
     * There are 3 kind of patterns supported:
     *     1. "*", it to matches any category name.
     *     2. Combine multiple categories with ",", for example "connections,messages", it matches category "connections" and "messages".
     *     3. The single category name, for example, "connections", it matches the category "connections".
     */
    @JvmName("asytfkhncydurxdh")
    public suspend fun categoryPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categoryPattern = mapped
    }

    /**
     * @param value Gets or sets the matching pattern for event names. If not set, it matches any event.
     * There are 3 kind of patterns supported:
     *     1. "*", it to matches any event name.
     *     2. Combine multiple events with ",", for example "connect,disconnect", it matches event "connect" and "disconnect".
     *     3. The single event name, for example, "connect", it matches "connect".
     */
    @JvmName("fhjwydquossjsxvk")
    public suspend fun eventPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventPattern = mapped
    }

    /**
     * @param value Gets or sets the matching pattern for hub names. If not set, it matches any hub.
     * There are 3 kind of patterns supported:
     *     1. "*", it to matches any hub name.
     *     2. Combine multiple hubs with ",", for example "hub1,hub2", it matches "hub1" and "hub2".
     *     3. The single hub name, for example, "hub1", it matches "hub1".
     */
    @JvmName("uikjahsehatxibvg")
    public suspend fun hubPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubPattern = mapped
    }

    /**
     * @param value Gets or sets the Upstream URL template. You can use 3 predefined parameters {hub}, {category} {event} inside the template, the value of the Upstream URL is dynamically calculated when the client request comes in.
     * For example, if the urlTemplate is `http://example.com/{hub}/api/{event}`, with a client request from hub `chat` connects, it will first POST to this URL: `http://example.com/chat/api/connect`.
     */
    @JvmName("kwdkaeuwiutxwxhm")
    public suspend fun urlTemplate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlTemplate = mapped
    }

    internal fun build(): UpstreamTemplateArgs = UpstreamTemplateArgs(
        auth = auth,
        categoryPattern = categoryPattern,
        eventPattern = eventPattern,
        hubPattern = hubPattern,
        urlTemplate = urlTemplate ?: throw PulumiNullFieldException("urlTemplate"),
    )
}
