@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The settings for the Upstream when the service is in server-less mode.
 * @property templates Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
 */
public data class ServerlessUpstreamSettingsResponse(
    public val templates: List<UpstreamTemplateResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.ServerlessUpstreamSettingsResponse):
            ServerlessUpstreamSettingsResponse = ServerlessUpstreamSettingsResponse(
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.signalrservice.kotlin.outputs.UpstreamTemplateResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
