@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cross-Origin Resource Sharing (CORS) settings.
 * @property allowedOrigins Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
 */
public data class SignalRCorsSettingsResponse(
    public val allowedOrigins: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.SignalRCorsSettingsResponse):
            SignalRCorsSettingsResponse = SignalRCorsSettingsResponse(
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
        )
    }
}
