@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.softwareplan.kotlin.inputs

import com.pulumi.azurenative.softwareplan.inputs.GetHybridUseBenefitPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property planId This is a unique identifier for a plan. Should be a guid.
 * @property scope The scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines and Microsoft.Compute/hostGroups/hosts for now
 */
public data class GetHybridUseBenefitPlainArgs(
    public val planId: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.softwareplan.inputs.GetHybridUseBenefitPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.softwareplan.inputs.GetHybridUseBenefitPlainArgs =
        com.pulumi.azurenative.softwareplan.inputs.GetHybridUseBenefitPlainArgs.builder()
            .planId(planId.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridUseBenefitPlainArgs].
 */
@PulumiTagMarker
public class GetHybridUseBenefitPlainArgsBuilder internal constructor() {
    private var planId: String? = null

    private var scope: String? = null

    /**
     * @param value This is a unique identifier for a plan. Should be a guid.
     */
    @JvmName("otolnjbydisenljr")
    public suspend fun planId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.planId = mapped
    }

    /**
     * @param value The scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines and Microsoft.Compute/hostGroups/hosts for now
     */
    @JvmName("ikrblfxjaojcfaah")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetHybridUseBenefitPlainArgs = GetHybridUseBenefitPlainArgs(
        planId = planId ?: throw PulumiNullFieldException("planId"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
