@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.softwareplan.kotlin.inputs

import com.pulumi.azurenative.softwareplan.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU to be applied for this resource
 * @property name Name of the SKU to be applied
 */
public data class SkuArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.softwareplan.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.softwareplan.inputs.SkuArgs =
        com.pulumi.azurenative.softwareplan.inputs.SkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the SKU to be applied
     */
    @JvmName("ddxutvvlihscwbcm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the SKU to be applied
     */
    @JvmName("vjygrfrxpangikui")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name,
    )
}
