@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationJitAccessPolicyArgs.builder
import com.pulumi.azurenative.solutions.kotlin.enums.JitApprovalMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed application Jit access policy.
 * @property jitAccessEnabled Whether the JIT access is enabled.
 * @property jitApprovalMode JIT approval mode.
 * @property jitApprovers The JIT approvers
 * @property maximumJitAccessDuration The maximum duration JIT access is granted. This is an ISO8601 time period value.
 */
public data class ApplicationJitAccessPolicyArgs(
    public val jitAccessEnabled: Output<Boolean>,
    public val jitApprovalMode: Output<Either<String, JitApprovalMode>>? = null,
    public val jitApprovers: Output<List<JitApproverDefinitionArgs>>? = null,
    public val maximumJitAccessDuration: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationJitAccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ApplicationJitAccessPolicyArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationJitAccessPolicyArgs.builder()
            .jitAccessEnabled(jitAccessEnabled.applyValue({ args0 -> args0 }))
            .jitApprovalMode(
                jitApprovalMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .jitApprovers(
                jitApprovers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .maximumJitAccessDuration(maximumJitAccessDuration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationJitAccessPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationJitAccessPolicyArgsBuilder internal constructor() {
    private var jitAccessEnabled: Output<Boolean>? = null

    private var jitApprovalMode: Output<Either<String, JitApprovalMode>>? = null

    private var jitApprovers: Output<List<JitApproverDefinitionArgs>>? = null

    private var maximumJitAccessDuration: Output<String>? = null

    /**
     * @param value Whether the JIT access is enabled.
     */
    @JvmName("xrkpisordlyuivwd")
    public suspend fun jitAccessEnabled(`value`: Output<Boolean>) {
        this.jitAccessEnabled = value
    }

    /**
     * @param value JIT approval mode.
     */
    @JvmName("ihxxmqssyllqhupd")
    public suspend fun jitApprovalMode(`value`: Output<Either<String, JitApprovalMode>>) {
        this.jitApprovalMode = value
    }

    /**
     * @param value The JIT approvers
     */
    @JvmName("etomoyqtvybkyggd")
    public suspend fun jitApprovers(`value`: Output<List<JitApproverDefinitionArgs>>) {
        this.jitApprovers = value
    }

    @JvmName("fcwjqdeooybjetvi")
    public suspend fun jitApprovers(vararg values: Output<JitApproverDefinitionArgs>) {
        this.jitApprovers = Output.all(values.asList())
    }

    /**
     * @param values The JIT approvers
     */
    @JvmName("pyrrkferqnbxkfdy")
    public suspend fun jitApprovers(values: List<Output<JitApproverDefinitionArgs>>) {
        this.jitApprovers = Output.all(values)
    }

    /**
     * @param value The maximum duration JIT access is granted. This is an ISO8601 time period value.
     */
    @JvmName("nqtcgppacxionjiu")
    public suspend fun maximumJitAccessDuration(`value`: Output<String>) {
        this.maximumJitAccessDuration = value
    }

    /**
     * @param value Whether the JIT access is enabled.
     */
    @JvmName("vyklutjdxtimebgh")
    public suspend fun jitAccessEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jitAccessEnabled = mapped
    }

    /**
     * @param value JIT approval mode.
     */
    @JvmName("edbfutruyeattkee")
    public suspend fun jitApprovalMode(`value`: Either<String, JitApprovalMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jitApprovalMode = mapped
    }

    /**
     * @param value JIT approval mode.
     */
    @JvmName("gcussinrdlvwjfft")
    public fun jitApprovalMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JitApprovalMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jitApprovalMode = mapped
    }

    /**
     * @param value JIT approval mode.
     */
    @JvmName("xkeyivvliqctvpce")
    public fun jitApprovalMode(`value`: JitApprovalMode) {
        val toBeMapped = Either.ofRight<String, JitApprovalMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jitApprovalMode = mapped
    }

    /**
     * @param value The JIT approvers
     */
    @JvmName("eqawwujdrwcykyjg")
    public suspend fun jitApprovers(`value`: List<JitApproverDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jitApprovers = mapped
    }

    /**
     * @param argument The JIT approvers
     */
    @JvmName("odpeoouxtmrslerj")
    public suspend
    fun jitApprovers(argument: List<suspend JitApproverDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JitApproverDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jitApprovers = mapped
    }

    /**
     * @param argument The JIT approvers
     */
    @JvmName("ibabskuoifdpqbor")
    public suspend fun jitApprovers(
        vararg
        argument: suspend JitApproverDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JitApproverDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jitApprovers = mapped
    }

    /**
     * @param argument The JIT approvers
     */
    @JvmName("ustuyrgkyevvomox")
    public suspend fun jitApprovers(argument: suspend JitApproverDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(JitApproverDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.jitApprovers = mapped
    }

    /**
     * @param values The JIT approvers
     */
    @JvmName("vhpfuuawspssfmcu")
    public suspend fun jitApprovers(vararg values: JitApproverDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jitApprovers = mapped
    }

    /**
     * @param value The maximum duration JIT access is granted. This is an ISO8601 time period value.
     */
    @JvmName("wqsqhljowaxhlyos")
    public suspend fun maximumJitAccessDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumJitAccessDuration = mapped
    }

    internal fun build(): ApplicationJitAccessPolicyArgs = ApplicationJitAccessPolicyArgs(
        jitAccessEnabled = jitAccessEnabled ?: throw PulumiNullFieldException("jitAccessEnabled"),
        jitApprovalMode = jitApprovalMode,
        jitApprovers = jitApprovers,
        maximumJitAccessDuration = maximumJitAccessDuration,
    )
}
