@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationManagementPolicyArgs.builder
import com.pulumi.azurenative.solutions.kotlin.enums.ApplicationManagementMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed application management policy.
 * @property mode The managed application management mode.
 */
public data class ApplicationManagementPolicyArgs(
    public val mode: Output<Either<String, ApplicationManagementMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationManagementPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ApplicationManagementPolicyArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationManagementPolicyArgs.builder()
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationManagementPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationManagementPolicyArgsBuilder internal constructor() {
    private var mode: Output<Either<String, ApplicationManagementMode>>? = null

    /**
     * @param value The managed application management mode.
     */
    @JvmName("smhptvryuoptifby")
    public suspend fun mode(`value`: Output<Either<String, ApplicationManagementMode>>) {
        this.mode = value
    }

    /**
     * @param value The managed application management mode.
     */
    @JvmName("omfprdeffpkrihdp")
    public suspend fun mode(`value`: Either<String, ApplicationManagementMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The managed application management mode.
     */
    @JvmName("mcqjoceloennxdyy")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationManagementMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The managed application management mode.
     */
    @JvmName("vjwwbdtypvtgdscp")
    public fun mode(`value`: ApplicationManagementMode) {
        val toBeMapped = Either.ofRight<String, ApplicationManagementMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): ApplicationManagementPolicyArgs = ApplicationManagementPolicyArgs(
        mode = mode,
    )
}
