@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationNotificationEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed application notification endpoint.
 * @property uri The managed application notification endpoint uri.
 */
public data class ApplicationNotificationEndpointArgs(
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationNotificationEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ApplicationNotificationEndpointArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationNotificationEndpointArgs.builder()
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationNotificationEndpointArgs].
 */
@PulumiTagMarker
public class ApplicationNotificationEndpointArgsBuilder internal constructor() {
    private var uri: Output<String>? = null

    /**
     * @param value The managed application notification endpoint uri.
     */
    @JvmName("kdaxyqrkcguuldqg")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The managed application notification endpoint uri.
     */
    @JvmName("vhvllwrmbdxkcuet")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ApplicationNotificationEndpointArgs = ApplicationNotificationEndpointArgs(
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
