@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationNotificationPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed application notification policy.
 * @property notificationEndpoints The managed application notification endpoint.
 */
public data class ApplicationNotificationPolicyArgs(
    public val notificationEndpoints: Output<List<ApplicationNotificationEndpointArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationNotificationPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ApplicationNotificationPolicyArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationNotificationPolicyArgs.builder()
            .notificationEndpoints(
                notificationEndpoints.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationNotificationPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationNotificationPolicyArgsBuilder internal constructor() {
    private var notificationEndpoints: Output<List<ApplicationNotificationEndpointArgs>>? = null

    /**
     * @param value The managed application notification endpoint.
     */
    @JvmName("urxyadjbklphoqah")
    public suspend
    fun notificationEndpoints(`value`: Output<List<ApplicationNotificationEndpointArgs>>) {
        this.notificationEndpoints = value
    }

    @JvmName("iretfnxkeplcovrp")
    public suspend fun notificationEndpoints(
        vararg
        values: Output<ApplicationNotificationEndpointArgs>,
    ) {
        this.notificationEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The managed application notification endpoint.
     */
    @JvmName("ehdnuwpqpaknhlam")
    public suspend
    fun notificationEndpoints(values: List<Output<ApplicationNotificationEndpointArgs>>) {
        this.notificationEndpoints = Output.all(values)
    }

    /**
     * @param value The managed application notification endpoint.
     */
    @JvmName("qtwpxeixmqykvkks")
    public suspend fun notificationEndpoints(`value`: List<ApplicationNotificationEndpointArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationEndpoints = mapped
    }

    /**
     * @param argument The managed application notification endpoint.
     */
    @JvmName("olfcuonxsefvkihx")
    public suspend
    fun notificationEndpoints(argument: List<suspend ApplicationNotificationEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationNotificationEndpointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationEndpoints = mapped
    }

    /**
     * @param argument The managed application notification endpoint.
     */
    @JvmName("ifraljltnrpjbyor")
    public suspend fun notificationEndpoints(
        vararg
        argument: suspend ApplicationNotificationEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationNotificationEndpointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationEndpoints = mapped
    }

    /**
     * @param argument The managed application notification endpoint.
     */
    @JvmName("bxgfrgxsaagkakpm")
    public suspend
    fun notificationEndpoints(argument: suspend ApplicationNotificationEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationNotificationEndpointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.notificationEndpoints = mapped
    }

    /**
     * @param values The managed application notification endpoint.
     */
    @JvmName("klnqaxtjefyghfeo")
    public suspend fun notificationEndpoints(vararg values: ApplicationNotificationEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationEndpoints = mapped
    }

    internal fun build(): ApplicationNotificationPolicyArgs = ApplicationNotificationPolicyArgs(
        notificationEndpoints = notificationEndpoints ?: throw
            PulumiNullFieldException("notificationEndpoints"),
    )
}
