@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationPackageLockingPolicyDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed application locking policy.
 * @property allowedActions The deny assignment excluded actions.
 * @property allowedDataActions The deny assignment excluded data actions.
 */
public data class ApplicationPackageLockingPolicyDefinitionArgs(
    public val allowedActions: Output<List<String>>? = null,
    public val allowedDataActions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationPackageLockingPolicyDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.solutions.inputs.ApplicationPackageLockingPolicyDefinitionArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationPackageLockingPolicyDefinitionArgs.builder()
            .allowedActions(allowedActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedDataActions(
                allowedDataActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationPackageLockingPolicyDefinitionArgs].
 */
@PulumiTagMarker
public class ApplicationPackageLockingPolicyDefinitionArgsBuilder internal constructor() {
    private var allowedActions: Output<List<String>>? = null

    private var allowedDataActions: Output<List<String>>? = null

    /**
     * @param value The deny assignment excluded actions.
     */
    @JvmName("olxvhricjtusvcib")
    public suspend fun allowedActions(`value`: Output<List<String>>) {
        this.allowedActions = value
    }

    @JvmName("pxiuqvfdvrgpstqh")
    public suspend fun allowedActions(vararg values: Output<String>) {
        this.allowedActions = Output.all(values.asList())
    }

    /**
     * @param values The deny assignment excluded actions.
     */
    @JvmName("xpqtbnyyqeuwdpdx")
    public suspend fun allowedActions(values: List<Output<String>>) {
        this.allowedActions = Output.all(values)
    }

    /**
     * @param value The deny assignment excluded data actions.
     */
    @JvmName("nfitpbutwheyxyaw")
    public suspend fun allowedDataActions(`value`: Output<List<String>>) {
        this.allowedDataActions = value
    }

    @JvmName("kvakpgjywgbnwcwc")
    public suspend fun allowedDataActions(vararg values: Output<String>) {
        this.allowedDataActions = Output.all(values.asList())
    }

    /**
     * @param values The deny assignment excluded data actions.
     */
    @JvmName("fmextbjhvjvpfdhx")
    public suspend fun allowedDataActions(values: List<Output<String>>) {
        this.allowedDataActions = Output.all(values)
    }

    /**
     * @param value The deny assignment excluded actions.
     */
    @JvmName("pxiecyiqnpdwggal")
    public suspend fun allowedActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedActions = mapped
    }

    /**
     * @param values The deny assignment excluded actions.
     */
    @JvmName("mqloltjhrmmvbtro")
    public suspend fun allowedActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedActions = mapped
    }

    /**
     * @param value The deny assignment excluded data actions.
     */
    @JvmName("lnricngdmbmyrpuv")
    public suspend fun allowedDataActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedDataActions = mapped
    }

    /**
     * @param values The deny assignment excluded data actions.
     */
    @JvmName("cdthfanagcfydauj")
    public suspend fun allowedDataActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedDataActions = mapped
    }

    internal fun build(): ApplicationPackageLockingPolicyDefinitionArgs =
        ApplicationPackageLockingPolicyDefinitionArgs(
            allowedActions = allowedActions,
            allowedDataActions = allowedDataActions,
        )
}
