@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ListApplicationAllowedUpgradePlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The name of the managed application.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListApplicationAllowedUpgradePlansPlainArgs(
    public val applicationName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ListApplicationAllowedUpgradePlansPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.solutions.inputs.ListApplicationAllowedUpgradePlansPlainArgs =
        com.pulumi.azurenative.solutions.inputs.ListApplicationAllowedUpgradePlansPlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListApplicationAllowedUpgradePlansPlainArgs].
 */
@PulumiTagMarker
public class ListApplicationAllowedUpgradePlansPlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the managed application.
     */
    @JvmName("nflaqenwbnhnjegf")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sigxjywuwjeifekb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListApplicationAllowedUpgradePlansPlainArgs =
        ListApplicationAllowedUpgradePlansPlainArgs(
            applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
