@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ListApplicationTokensPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The name of the managed application.
 * @property authorizationAudience The authorization audience.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property userAssignedIdentities The user assigned identities.
 */
public data class ListApplicationTokensPlainArgs(
    public val applicationName: String,
    public val authorizationAudience: String? = null,
    public val resourceGroupName: String,
    public val userAssignedIdentities: List<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ListApplicationTokensPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ListApplicationTokensPlainArgs =
        com.pulumi.azurenative.solutions.inputs.ListApplicationTokensPlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .authorizationAudience(authorizationAudience?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .userAssignedIdentities(
                userAssignedIdentities?.let({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ListApplicationTokensPlainArgs].
 */
@PulumiTagMarker
public class ListApplicationTokensPlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var authorizationAudience: String? = null

    private var resourceGroupName: String? = null

    private var userAssignedIdentities: List<String>? = null

    /**
     * @param value The name of the managed application.
     */
    @JvmName("intmqwneqpndwdcn")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The authorization audience.
     */
    @JvmName("ragqmnjlhqqqplkj")
    public suspend fun authorizationAudience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.authorizationAudience = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dptdvjwemkfybqob")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The user assigned identities.
     */
    @JvmName("ynyxcluoowljtvop")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The user assigned identities.
     */
    @JvmName("yygepnlwphdceilu")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ListApplicationTokensPlainArgs = ListApplicationTokensPlainArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        authorizationAudience = authorizationAudience,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
