@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The JIT authorization policies.
 * @property principalId The the principal id that will be granted JIT access.
 * @property roleDefinitionId The role definition id that will be granted to the Principal.
 */
public data class JitAuthorizationPoliciesResponse(
    public val principalId: String,
    public val roleDefinitionId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.JitAuthorizationPoliciesResponse):
            JitAuthorizationPoliciesResponse = JitAuthorizationPoliciesResponse(
            principalId = javaType.principalId(),
            roleDefinitionId = javaType.roleDefinitionId(),
        )
    }
}
