@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.DataMaskingPolicyArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.DataMaskingState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A database data masking policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update data masking policy max
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataMaskingPolicy = new AzureNative.Sql.DataMaskingPolicy("dataMaskingPolicy", new()
 *     {
 *         DataMaskingPolicyName = "Default",
 *         DataMaskingState = AzureNative.Sql.DataMaskingState.Enabled,
 *         DatabaseName = "sqlcrudtest-331",
 *         ExemptPrincipals = "testuser;",
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         ServerName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDataMaskingPolicy(ctx, "dataMaskingPolicy", &sql.DataMaskingPolicyArgs{
 * 			DataMaskingPolicyName: pulumi.String("Default"),
 * 			DataMaskingState:      sql.DataMaskingStateEnabled,
 * 			DatabaseName:          pulumi.String("sqlcrudtest-331"),
 * 			ExemptPrincipals:      pulumi.String("testuser;"),
 * 			ResourceGroupName:     pulumi.String("sqlcrudtest-6852"),
 * 			ServerName:            pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DataMaskingPolicy;
 * import com.pulumi.azurenative.sql.DataMaskingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataMaskingPolicy = new DataMaskingPolicy("dataMaskingPolicy", DataMaskingPolicyArgs.builder()
 *             .dataMaskingPolicyName("Default")
 *             .dataMaskingState("Enabled")
 *             .databaseName("sqlcrudtest-331")
 *             .exemptPrincipals("testuser;")
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .serverName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update data masking policy min.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataMaskingPolicy = new AzureNative.Sql.DataMaskingPolicy("dataMaskingPolicy", new()
 *     {
 *         DataMaskingPolicyName = "Default",
 *         DataMaskingState = AzureNative.Sql.DataMaskingState.Enabled,
 *         DatabaseName = "sqlcrudtest-331",
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         ServerName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDataMaskingPolicy(ctx, "dataMaskingPolicy", &sql.DataMaskingPolicyArgs{
 * 			DataMaskingPolicyName: pulumi.String("Default"),
 * 			DataMaskingState:      sql.DataMaskingStateEnabled,
 * 			DatabaseName:          pulumi.String("sqlcrudtest-331"),
 * 			ResourceGroupName:     pulumi.String("sqlcrudtest-6852"),
 * 			ServerName:            pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DataMaskingPolicy;
 * import com.pulumi.azurenative.sql.DataMaskingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataMaskingPolicy = new DataMaskingPolicy("dataMaskingPolicy", DataMaskingPolicyArgs.builder()
 *             .dataMaskingPolicyName("Default")
 *             .dataMaskingState("Enabled")
 *             .databaseName("sqlcrudtest-331")
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .serverName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DataMaskingPolicy Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}
 * ```
 * @property dataMaskingPolicyName The name of the database for which the data masking policy applies.
 * @property dataMaskingState The state of the data masking policy.
 * @property databaseName The name of the database.
 * @property exemptPrincipals The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class DataMaskingPolicyArgs(
    public val dataMaskingPolicyName: Output<String>? = null,
    public val dataMaskingState: Output<DataMaskingState>? = null,
    public val databaseName: Output<String>? = null,
    public val exemptPrincipals: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.DataMaskingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.DataMaskingPolicyArgs =
        com.pulumi.azurenative.sql.DataMaskingPolicyArgs.builder()
            .dataMaskingPolicyName(dataMaskingPolicyName?.applyValue({ args0 -> args0 }))
            .dataMaskingState(dataMaskingState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .exemptPrincipals(exemptPrincipals?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataMaskingPolicyArgs].
 */
@PulumiTagMarker
public class DataMaskingPolicyArgsBuilder internal constructor() {
    private var dataMaskingPolicyName: Output<String>? = null

    private var dataMaskingState: Output<DataMaskingState>? = null

    private var databaseName: Output<String>? = null

    private var exemptPrincipals: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of the database for which the data masking policy applies.
     */
    @JvmName("wxkjbbysvjpoleqx")
    public suspend fun dataMaskingPolicyName(`value`: Output<String>) {
        this.dataMaskingPolicyName = value
    }

    /**
     * @param value The state of the data masking policy.
     */
    @JvmName("dpsvdbhuhrfekpfu")
    public suspend fun dataMaskingState(`value`: Output<DataMaskingState>) {
        this.dataMaskingState = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("njkskgbntkbldbpk")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
     */
    @JvmName("mijsqyvhydvlbetp")
    public suspend fun exemptPrincipals(`value`: Output<String>) {
        this.exemptPrincipals = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qpxeubwgesdgvujc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("dtmqqfkxpcmawcpl")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the database for which the data masking policy applies.
     */
    @JvmName("tmusqsisawtcpkmh")
    public suspend fun dataMaskingPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataMaskingPolicyName = mapped
    }

    /**
     * @param value The state of the data masking policy.
     */
    @JvmName("ghnmebkeqscvefbe")
    public suspend fun dataMaskingState(`value`: DataMaskingState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataMaskingState = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("oceglkkkeusvypyw")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
     */
    @JvmName("tekxmktlmlxddnxs")
    public suspend fun exemptPrincipals(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exemptPrincipals = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lvwhoptqsyyqlrfk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("jcybrlcilyjsvsyu")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): DataMaskingPolicyArgs = DataMaskingPolicyArgs(
        dataMaskingPolicyName = dataMaskingPolicyName,
        dataMaskingState = dataMaskingState,
        databaseName = databaseName,
        exemptPrincipals = exemptPrincipals,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
