@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.DatabaseAdvisorArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.AutoExecuteStatus
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Database, Server or Elastic Pool Advisor.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Update database advisor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseAdvisor = new AzureNative.Sql.DatabaseAdvisor("databaseAdvisor", new()
 *     {
 *         AdvisorName = "CreateIndex",
 *         AutoExecuteStatus = AzureNative.Sql.AutoExecuteStatus.Disabled,
 *         DatabaseName = "IndexAdvisor_test_3",
 *         ResourceGroupName = "workloadinsight-demos",
 *         ServerName = "misosisvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseAdvisor(ctx, "databaseAdvisor", &sql.DatabaseAdvisorArgs{
 * 			AdvisorName:       pulumi.String("CreateIndex"),
 * 			AutoExecuteStatus: sql.AutoExecuteStatusDisabled,
 * 			DatabaseName:      pulumi.String("IndexAdvisor_test_3"),
 * 			ResourceGroupName: pulumi.String("workloadinsight-demos"),
 * 			ServerName:        pulumi.String("misosisvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseAdvisor;
 * import com.pulumi.azurenative.sql.DatabaseAdvisorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseAdvisor = new DatabaseAdvisor("databaseAdvisor", DatabaseAdvisorArgs.builder()
 *             .advisorName("CreateIndex")
 *             .autoExecuteStatus("Disabled")
 *             .databaseName("IndexAdvisor_test_3")
 *             .resourceGroupName("workloadinsight-demos")
 *             .serverName("misosisvr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseAdvisor CreateIndex /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors/{advisorName}
 * ```
 * @property advisorName The name of the Database Advisor.
 * @property autoExecuteStatus Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
 * @property databaseName The name of the database.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class DatabaseAdvisorArgs(
    public val advisorName: Output<String>? = null,
    public val autoExecuteStatus: Output<AutoExecuteStatus>? = null,
    public val databaseName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.DatabaseAdvisorArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.DatabaseAdvisorArgs =
        com.pulumi.azurenative.sql.DatabaseAdvisorArgs.builder()
            .advisorName(advisorName?.applyValue({ args0 -> args0 }))
            .autoExecuteStatus(autoExecuteStatus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseAdvisorArgs].
 */
@PulumiTagMarker
public class DatabaseAdvisorArgsBuilder internal constructor() {
    private var advisorName: Output<String>? = null

    private var autoExecuteStatus: Output<AutoExecuteStatus>? = null

    private var databaseName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of the Database Advisor.
     */
    @JvmName("qxyfxpedavhqcetl")
    public suspend fun advisorName(`value`: Output<String>) {
        this.advisorName = value
    }

    /**
     * @param value Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
     */
    @JvmName("dgqpgrtlhnqaochi")
    public suspend fun autoExecuteStatus(`value`: Output<AutoExecuteStatus>) {
        this.autoExecuteStatus = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("fobbqqsddkvaldbo")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("cbcnltiyhfjbbeca")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("vtgwseehlwjsryms")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the Database Advisor.
     */
    @JvmName("bbwgfuycomkwtixh")
    public suspend fun advisorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advisorName = mapped
    }

    /**
     * @param value Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
     */
    @JvmName("bpqrscingrbbjkxf")
    public suspend fun autoExecuteStatus(`value`: AutoExecuteStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoExecuteStatus = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("fhhkuomqavbqrocr")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rvouhctomlbghapv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("oigdmpypysaecuhr")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): DatabaseAdvisorArgs = DatabaseAdvisorArgs(
        advisorName = advisorName,
        autoExecuteStatus = autoExecuteStatus,
        databaseName = databaseName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
