@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A database sql vulnerability assessment rule baseline.
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates or updates a database's vulnerability assessment rule baseline.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseSqlVulnerabilityAssessmentRuleBaseline = new AzureNative.Sql.DatabaseSqlVulnerabilityAssessmentRuleBaseline("databaseSqlVulnerabilityAssessmentRuleBaseline", new()
 *     {
 *         BaselineName = "default",
 *         DatabaseName = "testdb",
 *         LatestScan = false,
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         Results = new[]
 *         {
 *             new[]
 *             {
 *                 "userA",
 *                 "SELECT",
 *             },
 *             new[]
 *             {
 *                 "userB",
 *                 "SELECT",
 *             },
 *             new[]
 *             {
 *                 "userC",
 *                 "SELECT",
 *             },
 *         },
 *         RuleId = "VA1001",
 *         ServerName = "vulnerabilityaseessmenttest-6440",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseSqlVulnerabilityAssessmentRuleBaseline(ctx, "databaseSqlVulnerabilityAssessmentRuleBaseline", &sql.DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs{
 * 			BaselineName:      pulumi.String("default"),
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			LatestScan:        pulumi.Bool(false),
 * 			ResourceGroupName: pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			Results: pulumi.StringArrayArray{
 * 				pulumi.StringArray{
 * 					pulumi.String("userA"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("userB"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("userC"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 			},
 * 			RuleId:                      pulumi.String("VA1001"),
 * 			ServerName:                  pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaseline;
 * import com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseSqlVulnerabilityAssessmentRuleBaseline = new DatabaseSqlVulnerabilityAssessmentRuleBaseline("databaseSqlVulnerabilityAssessmentRuleBaseline", DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs.builder()
 *             .baselineName("default")
 *             .databaseName("testdb")
 *             .latestScan(false)
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .results(
 *                     "userA",
 *                     "SELECT",
 *                     "userB",
 *                     "SELECT",
 *                     "userC",
 *                     "SELECT")
 *             .ruleId("VA1001")
 *             .serverName("vulnerabilityaseessmenttest-6440")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseSqlVulnerabilityAssessmentRuleBaseline Scan123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}
 * ```
 * @property baselineName
 * @property databaseName The name of the database.
 * @property latestScan The latest scan flag
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property results The rule baseline result
 * @property ruleId The vulnerability assessment rule ID.
 * @property serverName The name of the server.
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 */
public data class DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs(
    public val baselineName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val latestScan: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val results: Output<List<List<String>>>? = null,
    public val ruleId: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val vulnerabilityAssessmentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs =
        com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs.builder()
            .baselineName(baselineName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .latestScan(latestScan?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .results(results?.applyValue({ args0 -> args0.map({ args0 -> args0.map({ args0 -> args0 }) }) }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs].
 */
@PulumiTagMarker
public class DatabaseSqlVulnerabilityAssessmentRuleBaselineArgsBuilder internal constructor() {
    private var baselineName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var latestScan: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var results: Output<List<List<String>>>? = null

    private var ruleId: Output<String>? = null

    private var serverName: Output<String>? = null

    private var vulnerabilityAssessmentName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("jdnclburjbchyhyq")
    public suspend fun baselineName(`value`: Output<String>) {
        this.baselineName = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("gtgjkqpwofiusjxk")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The latest scan flag
     */
    @JvmName("ihcefdndvibmddbc")
    public suspend fun latestScan(`value`: Output<Boolean>) {
        this.latestScan = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("haemuaxhcsaytlrn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rule baseline result
     */
    @JvmName("qdbxkdwsaanbxlse")
    public suspend fun results(`value`: Output<List<List<String>>>) {
        this.results = value
    }

    @JvmName("ggortpgiucauvcev")
    public suspend fun results(vararg values: Output<List<String>>) {
        this.results = Output.all(values.asList())
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("wmmqyhckdcjotchn")
    public suspend fun results(values: List<Output<List<String>>>) {
        this.results = Output.all(values)
    }

    /**
     * @param value The vulnerability assessment rule ID.
     */
    @JvmName("wwbkqxrtsnaxibte")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("simhfwwhhvdymdal")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("wliuyilvbivcmulh")
    public suspend fun vulnerabilityAssessmentName(`value`: Output<String>) {
        this.vulnerabilityAssessmentName = value
    }

    /**
     * @param value
     */
    @JvmName("qioudpicjanktggp")
    public suspend fun baselineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("ggjnrieadrwaensg")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The latest scan flag
     */
    @JvmName("uwhtfmnwqkvfqods")
    public suspend fun latestScan(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latestScan = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ixrvrnkerneoqvmr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rule baseline result
     */
    @JvmName("phnnhlkqfnacidlc")
    public suspend fun results(`value`: List<List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.results = mapped
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("ccqpkdsfcwosxpsy")
    public suspend fun results(vararg values: List<String>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.results = mapped
    }

    /**
     * @param value The vulnerability assessment rule ID.
     */
    @JvmName("rpcmvfgetlosvlfa")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("xenkaxquglgmddug")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("evugummkjuitgvwe")
    public suspend fun vulnerabilityAssessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulnerabilityAssessmentName = mapped
    }

    internal fun build(): DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs =
        DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs(
            baselineName = baselineName,
            databaseName = databaseName,
            latestScan = latestScan,
            resourceGroupName = resourceGroupName,
            results = results,
            ruleId = ruleId,
            serverName = serverName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
}
