@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DistributedAvailabilityGroup].
 */
@PulumiTagMarker
public class DistributedAvailabilityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DistributedAvailabilityGroupArgs = DistributedAvailabilityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DistributedAvailabilityGroupArgsBuilder.() -> Unit) {
        val builder = DistributedAvailabilityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DistributedAvailabilityGroup {
        val builtJavaResource =
            com.pulumi.azurenative.sql.DistributedAvailabilityGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DistributedAvailabilityGroup(builtJavaResource)
    }
}

/**
 * Distributed availability group between box and Sql Managed Instance.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a distributed availability group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var distributedAvailabilityGroup = new AzureNative.Sql.DistributedAvailabilityGroup("distributedAvailabilityGroup", new()
 *     {
 *         DistributedAvailabilityGroupName = "dag",
 *         ManagedInstanceName = "testcl",
 *         PrimaryAvailabilityGroupName = "BoxLocalAg1",
 *         ResourceGroupName = "testrg",
 *         SecondaryAvailabilityGroupName = "testcl",
 *         SourceEndpoint = "TCP://SERVER:7022",
 *         TargetDatabase = "testdb",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDistributedAvailabilityGroup(ctx, "distributedAvailabilityGroup", &sql.DistributedAvailabilityGroupArgs{
 * 			DistributedAvailabilityGroupName: pulumi.String("dag"),
 * 			ManagedInstanceName:              pulumi.String("testcl"),
 * 			PrimaryAvailabilityGroupName:     pulumi.String("BoxLocalAg1"),
 * 			ResourceGroupName:                pulumi.String("testrg"),
 * 			SecondaryAvailabilityGroupName:   pulumi.String("testcl"),
 * 			SourceEndpoint:                   pulumi.String("TCP://SERVER:7022"),
 * 			TargetDatabase:                   pulumi.String("testdb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DistributedAvailabilityGroup;
 * import com.pulumi.azurenative.sql.DistributedAvailabilityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var distributedAvailabilityGroup = new DistributedAvailabilityGroup("distributedAvailabilityGroup", DistributedAvailabilityGroupArgs.builder()
 *             .distributedAvailabilityGroupName("dag")
 *             .managedInstanceName("testcl")
 *             .primaryAvailabilityGroupName("BoxLocalAg1")
 *             .resourceGroupName("testrg")
 *             .secondaryAvailabilityGroupName("testcl")
 *             .sourceEndpoint("TCP://SERVER:7022")
 *             .targetDatabase("testdb")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DistributedAvailabilityGroup dag /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/distributedAvailabilityGroups/{distributedAvailabilityGroupName}
 * ```
 */
public class DistributedAvailabilityGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.DistributedAvailabilityGroup,
) : KotlinCustomResource(javaResource, DistributedAvailabilityGroupMapper) {
    /**
     * The distributed availability group id
     */
    public val distributedAvailabilityGroupId: Output<String>
        get() = javaResource.distributedAvailabilityGroupId().applyValue({ args0 -> args0 })

    /**
     * The last hardened lsn
     */
    public val lastHardenedLsn: Output<String>
        get() = javaResource.lastHardenedLsn().applyValue({ args0 -> args0 })

    /**
     * The link state
     */
    public val linkState: Output<String>
        get() = javaResource.linkState().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The primary availability group name
     */
    public val primaryAvailabilityGroupName: Output<String>?
        get() = javaResource.primaryAvailabilityGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The replication mode of a distributed availability group. Parameter will be ignored during link creation.
     */
    public val replicationMode: Output<String>?
        get() = javaResource.replicationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The secondary availability group name
     */
    public val secondaryAvailabilityGroupName: Output<String>?
        get() = javaResource.secondaryAvailabilityGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The source endpoint
     */
    public val sourceEndpoint: Output<String>?
        get() = javaResource.sourceEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The source replica id
     */
    public val sourceReplicaId: Output<String>
        get() = javaResource.sourceReplicaId().applyValue({ args0 -> args0 })

    /**
     * The name of the target database
     */
    public val targetDatabase: Output<String>?
        get() = javaResource.targetDatabase().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The target replica id
     */
    public val targetReplicaId: Output<String>
        get() = javaResource.targetReplicaId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DistributedAvailabilityGroupMapper : ResourceMapper<DistributedAvailabilityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.DistributedAvailabilityGroup::class == javaResource::class

    override fun map(javaResource: Resource): DistributedAvailabilityGroup =
        DistributedAvailabilityGroup(
            javaResource as
                com.pulumi.azurenative.sql.DistributedAvailabilityGroup,
        )
}

/**
 * @see [DistributedAvailabilityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DistributedAvailabilityGroup].
 */
public suspend fun distributedAvailabilityGroup(
    name: String,
    block: suspend DistributedAvailabilityGroupResourceBuilder.() -> Unit,
):
    DistributedAvailabilityGroup {
    val builder = DistributedAvailabilityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DistributedAvailabilityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun distributedAvailabilityGroup(name: String): DistributedAvailabilityGroup {
    val builder = DistributedAvailabilityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
