@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.DistributedAvailabilityGroupArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ReplicationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Distributed availability group between box and Sql Managed Instance.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a distributed availability group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var distributedAvailabilityGroup = new AzureNative.Sql.DistributedAvailabilityGroup("distributedAvailabilityGroup", new()
 *     {
 *         DistributedAvailabilityGroupName = "dag",
 *         ManagedInstanceName = "testcl",
 *         PrimaryAvailabilityGroupName = "BoxLocalAg1",
 *         ResourceGroupName = "testrg",
 *         SecondaryAvailabilityGroupName = "testcl",
 *         SourceEndpoint = "TCP://SERVER:7022",
 *         TargetDatabase = "testdb",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDistributedAvailabilityGroup(ctx, "distributedAvailabilityGroup", &sql.DistributedAvailabilityGroupArgs{
 * 			DistributedAvailabilityGroupName: pulumi.String("dag"),
 * 			ManagedInstanceName:              pulumi.String("testcl"),
 * 			PrimaryAvailabilityGroupName:     pulumi.String("BoxLocalAg1"),
 * 			ResourceGroupName:                pulumi.String("testrg"),
 * 			SecondaryAvailabilityGroupName:   pulumi.String("testcl"),
 * 			SourceEndpoint:                   pulumi.String("TCP://SERVER:7022"),
 * 			TargetDatabase:                   pulumi.String("testdb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DistributedAvailabilityGroup;
 * import com.pulumi.azurenative.sql.DistributedAvailabilityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var distributedAvailabilityGroup = new DistributedAvailabilityGroup("distributedAvailabilityGroup", DistributedAvailabilityGroupArgs.builder()
 *             .distributedAvailabilityGroupName("dag")
 *             .managedInstanceName("testcl")
 *             .primaryAvailabilityGroupName("BoxLocalAg1")
 *             .resourceGroupName("testrg")
 *             .secondaryAvailabilityGroupName("testcl")
 *             .sourceEndpoint("TCP://SERVER:7022")
 *             .targetDatabase("testdb")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DistributedAvailabilityGroup dag /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/distributedAvailabilityGroups/{distributedAvailabilityGroupName}
 * ```
 * @property distributedAvailabilityGroupName The distributed availability group name.
 * @property managedInstanceName The name of the managed instance.
 * @property primaryAvailabilityGroupName The primary availability group name
 * @property replicationMode The replication mode of a distributed availability group. Parameter will be ignored during link creation.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property secondaryAvailabilityGroupName The secondary availability group name
 * @property sourceEndpoint The source endpoint
 * @property targetDatabase The name of the target database
 */
public data class DistributedAvailabilityGroupArgs(
    public val distributedAvailabilityGroupName: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val primaryAvailabilityGroupName: Output<String>? = null,
    public val replicationMode: Output<Either<String, ReplicationMode>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secondaryAvailabilityGroupName: Output<String>? = null,
    public val sourceEndpoint: Output<String>? = null,
    public val targetDatabase: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.DistributedAvailabilityGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.DistributedAvailabilityGroupArgs =
        com.pulumi.azurenative.sql.DistributedAvailabilityGroupArgs.builder()
            .distributedAvailabilityGroupName(distributedAvailabilityGroupName?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .primaryAvailabilityGroupName(primaryAvailabilityGroupName?.applyValue({ args0 -> args0 }))
            .replicationMode(
                replicationMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secondaryAvailabilityGroupName(secondaryAvailabilityGroupName?.applyValue({ args0 -> args0 }))
            .sourceEndpoint(sourceEndpoint?.applyValue({ args0 -> args0 }))
            .targetDatabase(targetDatabase?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributedAvailabilityGroupArgs].
 */
@PulumiTagMarker
public class DistributedAvailabilityGroupArgsBuilder internal constructor() {
    private var distributedAvailabilityGroupName: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var primaryAvailabilityGroupName: Output<String>? = null

    private var replicationMode: Output<Either<String, ReplicationMode>>? = null

    private var resourceGroupName: Output<String>? = null

    private var secondaryAvailabilityGroupName: Output<String>? = null

    private var sourceEndpoint: Output<String>? = null

    private var targetDatabase: Output<String>? = null

    /**
     * @param value The distributed availability group name.
     */
    @JvmName("lvsfgrtuqpuxftjj")
    public suspend fun distributedAvailabilityGroupName(`value`: Output<String>) {
        this.distributedAvailabilityGroupName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("kcfsvpculpsrwvth")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The primary availability group name
     */
    @JvmName("muhqghovljueyogg")
    public suspend fun primaryAvailabilityGroupName(`value`: Output<String>) {
        this.primaryAvailabilityGroupName = value
    }

    /**
     * @param value The replication mode of a distributed availability group. Parameter will be ignored during link creation.
     */
    @JvmName("ngptmycrviijbvem")
    public suspend fun replicationMode(`value`: Output<Either<String, ReplicationMode>>) {
        this.replicationMode = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("bkmncqtosgsrfdak")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The secondary availability group name
     */
    @JvmName("iteynleaiyfepqns")
    public suspend fun secondaryAvailabilityGroupName(`value`: Output<String>) {
        this.secondaryAvailabilityGroupName = value
    }

    /**
     * @param value The source endpoint
     */
    @JvmName("oyilckbywkiqvqfv")
    public suspend fun sourceEndpoint(`value`: Output<String>) {
        this.sourceEndpoint = value
    }

    /**
     * @param value The name of the target database
     */
    @JvmName("qksvsnkpfojlkksj")
    public suspend fun targetDatabase(`value`: Output<String>) {
        this.targetDatabase = value
    }

    /**
     * @param value The distributed availability group name.
     */
    @JvmName("wopplkqtxhjnvuos")
    public suspend fun distributedAvailabilityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributedAvailabilityGroupName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("lccecvqotnarljae")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The primary availability group name
     */
    @JvmName("bmjqelwnfqhfxabx")
    public suspend fun primaryAvailabilityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryAvailabilityGroupName = mapped
    }

    /**
     * @param value The replication mode of a distributed availability group. Parameter will be ignored during link creation.
     */
    @JvmName("baqagpwiyoeetwwd")
    public suspend fun replicationMode(`value`: Either<String, ReplicationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value The replication mode of a distributed availability group. Parameter will be ignored during link creation.
     */
    @JvmName("pkptoefxmfcfnjrg")
    public fun replicationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value The replication mode of a distributed availability group. Parameter will be ignored during link creation.
     */
    @JvmName("mqxebhnonqnwyhqy")
    public fun replicationMode(`value`: ReplicationMode) {
        val toBeMapped = Either.ofRight<String, ReplicationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("eeqpadrxsrnufuel")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The secondary availability group name
     */
    @JvmName("nsqdbmsxccbriqic")
    public suspend fun secondaryAvailabilityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryAvailabilityGroupName = mapped
    }

    /**
     * @param value The source endpoint
     */
    @JvmName("elvjrcrramtraatw")
    public suspend fun sourceEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpoint = mapped
    }

    /**
     * @param value The name of the target database
     */
    @JvmName("ouihjqvhcpsgwmvm")
    public suspend fun targetDatabase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabase = mapped
    }

    internal fun build(): DistributedAvailabilityGroupArgs = DistributedAvailabilityGroupArgs(
        distributedAvailabilityGroupName = distributedAvailabilityGroupName,
        managedInstanceName = managedInstanceName,
        primaryAvailabilityGroupName = primaryAvailabilityGroupName,
        replicationMode = replicationMode,
        resourceGroupName = resourceGroupName,
        secondaryAvailabilityGroupName = secondaryAvailabilityGroupName,
        sourceEndpoint = sourceEndpoint,
        targetDatabase = targetDatabase,
    )
}
