@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ElasticPoolArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ElasticPoolLicenseType
import com.pulumi.azurenative.sql.kotlin.inputs.ElasticPoolPerDatabaseSettingsArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ElasticPoolPerDatabaseSettingsArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An elastic pool.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update Hyperscale elastic pool with high availability replica count parameter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticPool = new AzureNative.Sql.ElasticPool("elasticPool", new()
 *     {
 *         ElasticPoolName = "sqlcrudtest-8102",
 *         HighAvailabilityReplicaCount = 2,
 *         Location = "Japan East",
 *         ResourceGroupName = "sqlcrudtest-2369",
 *         ServerName = "sqlcrudtest-8069",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "HS_Gen5_4",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewElasticPool(ctx, "elasticPool", &sql.ElasticPoolArgs{
 * 			ElasticPoolName:              pulumi.String("sqlcrudtest-8102"),
 * 			HighAvailabilityReplicaCount: pulumi.Int(2),
 * 			Location:                     pulumi.String("Japan East"),
 * 			ResourceGroupName:            pulumi.String("sqlcrudtest-2369"),
 * 			ServerName:                   pulumi.String("sqlcrudtest-8069"),
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("HS_Gen5_4"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ElasticPool;
 * import com.pulumi.azurenative.sql.ElasticPoolArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticPool = new ElasticPool("elasticPool", ElasticPoolArgs.builder()
 *             .elasticPoolName("sqlcrudtest-8102")
 *             .highAvailabilityReplicaCount(2)
 *             .location("Japan East")
 *             .resourceGroupName("sqlcrudtest-2369")
 *             .serverName("sqlcrudtest-8069")
 *             .sku(SkuArgs.builder()
 *                 .name("HS_Gen5_4")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update elastic pool with all parameter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticPool = new AzureNative.Sql.ElasticPool("elasticPool", new()
 *     {
 *         ElasticPoolName = "sqlcrudtest-8102",
 *         Location = "Japan East",
 *         PerDatabaseSettings = new AzureNative.Sql.Inputs.ElasticPoolPerDatabaseSettingsArgs
 *         {
 *             MaxCapacity = 2,
 *             MinCapacity = 0.25,
 *         },
 *         ResourceGroupName = "sqlcrudtest-2369",
 *         ServerName = "sqlcrudtest-8069",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "GP_Gen4_2",
 *             Tier = "GeneralPurpose",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewElasticPool(ctx, "elasticPool", &sql.ElasticPoolArgs{
 * 			ElasticPoolName: pulumi.String("sqlcrudtest-8102"),
 * 			Location:        pulumi.String("Japan East"),
 * 			PerDatabaseSettings: &sql.ElasticPoolPerDatabaseSettingsArgs{
 * 				MaxCapacity: pulumi.Float64(2),
 * 				MinCapacity: pulumi.Float64(0.25),
 * 			},
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-2369"),
 * 			ServerName:        pulumi.String("sqlcrudtest-8069"),
 * 			Sku: &sql.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("GP_Gen4_2"),
 * 				Tier:     pulumi.String("GeneralPurpose"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ElasticPool;
 * import com.pulumi.azurenative.sql.ElasticPoolArgs;
 * import com.pulumi.azurenative.sql.inputs.ElasticPoolPerDatabaseSettingsArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticPool = new ElasticPool("elasticPool", ElasticPoolArgs.builder()
 *             .elasticPoolName("sqlcrudtest-8102")
 *             .location("Japan East")
 *             .perDatabaseSettings(ElasticPoolPerDatabaseSettingsArgs.builder()
 *                 .maxCapacity(2)
 *                 .minCapacity(0.25)
 *                 .build())
 *             .resourceGroupName("sqlcrudtest-2369")
 *             .serverName("sqlcrudtest-8069")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("GP_Gen4_2")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update elastic pool with maintenance configuration parameter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticPool = new AzureNative.Sql.ElasticPool("elasticPool", new()
 *     {
 *         ElasticPoolName = "sqlcrudtest-8102",
 *         Location = "Japan East",
 *         MaintenanceConfigurationId = "/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_1",
 *         ResourceGroupName = "sqlcrudtest-2369",
 *         ServerName = "sqlcrudtest-8069",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewElasticPool(ctx, "elasticPool", &sql.ElasticPoolArgs{
 * 			ElasticPoolName:            pulumi.String("sqlcrudtest-8102"),
 * 			Location:                   pulumi.String("Japan East"),
 * 			MaintenanceConfigurationId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_1"),
 * 			ResourceGroupName:          pulumi.String("sqlcrudtest-2369"),
 * 			ServerName:                 pulumi.String("sqlcrudtest-8069"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ElasticPool;
 * import com.pulumi.azurenative.sql.ElasticPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticPool = new ElasticPool("elasticPool", ElasticPoolArgs.builder()
 *             .elasticPoolName("sqlcrudtest-8102")
 *             .location("Japan East")
 *             .maintenanceConfigurationId("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_1")
 *             .resourceGroupName("sqlcrudtest-2369")
 *             .serverName("sqlcrudtest-8069")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update elastic pool with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticPool = new AzureNative.Sql.ElasticPool("elasticPool", new()
 *     {
 *         ElasticPoolName = "sqlcrudtest-8102",
 *         Location = "Japan East",
 *         ResourceGroupName = "sqlcrudtest-2369",
 *         ServerName = "sqlcrudtest-8069",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewElasticPool(ctx, "elasticPool", &sql.ElasticPoolArgs{
 * 			ElasticPoolName:   pulumi.String("sqlcrudtest-8102"),
 * 			Location:          pulumi.String("Japan East"),
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-2369"),
 * 			ServerName:        pulumi.String("sqlcrudtest-8069"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ElasticPool;
 * import com.pulumi.azurenative.sql.ElasticPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticPool = new ElasticPool("elasticPool", ElasticPoolArgs.builder()
 *             .elasticPoolName("sqlcrudtest-8102")
 *             .location("Japan East")
 *             .resourceGroupName("sqlcrudtest-2369")
 *             .serverName("sqlcrudtest-8069")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ElasticPool sqlcrudtest-8102 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}
 * ```
 * @property elasticPoolName The name of the elastic pool.
 * @property highAvailabilityReplicaCount The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable only to Hyperscale elastic pools.
 * @property licenseType The license type to apply for this elastic pool.
 * @property location Resource location.
 * @property maintenanceConfigurationId Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur.
 * @property maxSizeBytes The storage limit for the database elastic pool in bytes.
 * @property minCapacity Minimal capacity that serverless pool will not shrink below, if not paused
 * @property perDatabaseSettings The per database settings for the elastic pool.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property sku The elastic pool SKU.
 * The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
 * ```azurecli
 * az sql elastic-pool list-editions -l <location> -o table
 * ````
 * @property tags Resource tags.
 * @property zoneRedundant Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
 */
public data class ElasticPoolArgs(
    public val elasticPoolName: Output<String>? = null,
    public val highAvailabilityReplicaCount: Output<Int>? = null,
    public val licenseType: Output<Either<String, ElasticPoolLicenseType>>? = null,
    public val location: Output<String>? = null,
    public val maintenanceConfigurationId: Output<String>? = null,
    public val maxSizeBytes: Output<Double>? = null,
    public val minCapacity: Output<Double>? = null,
    public val perDatabaseSettings: Output<ElasticPoolPerDatabaseSettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneRedundant: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ElasticPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ElasticPoolArgs =
        com.pulumi.azurenative.sql.ElasticPoolArgs.builder()
            .elasticPoolName(elasticPoolName?.applyValue({ args0 -> args0 }))
            .highAvailabilityReplicaCount(highAvailabilityReplicaCount?.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceConfigurationId(maintenanceConfigurationId?.applyValue({ args0 -> args0 }))
            .maxSizeBytes(maxSizeBytes?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 }))
            .perDatabaseSettings(
                perDatabaseSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneRedundant(zoneRedundant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ElasticPoolArgs].
 */
@PulumiTagMarker
public class ElasticPoolArgsBuilder internal constructor() {
    private var elasticPoolName: Output<String>? = null

    private var highAvailabilityReplicaCount: Output<Int>? = null

    private var licenseType: Output<Either<String, ElasticPoolLicenseType>>? = null

    private var location: Output<String>? = null

    private var maintenanceConfigurationId: Output<String>? = null

    private var maxSizeBytes: Output<Double>? = null

    private var minCapacity: Output<Double>? = null

    private var perDatabaseSettings: Output<ElasticPoolPerDatabaseSettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneRedundant: Output<Boolean>? = null

    /**
     * @param value The name of the elastic pool.
     */
    @JvmName("xspblfqvodyciagq")
    public suspend fun elasticPoolName(`value`: Output<String>) {
        this.elasticPoolName = value
    }

    /**
     * @param value The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable only to Hyperscale elastic pools.
     */
    @JvmName("ijaotqimrtkvyccv")
    public suspend fun highAvailabilityReplicaCount(`value`: Output<Int>) {
        this.highAvailabilityReplicaCount = value
    }

    /**
     * @param value The license type to apply for this elastic pool.
     */
    @JvmName("awlolhrghtrjukdt")
    public suspend fun licenseType(`value`: Output<Either<String, ElasticPoolLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("siodeswmmmusykny")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur.
     */
    @JvmName("hqrbjvollhyfecxi")
    public suspend fun maintenanceConfigurationId(`value`: Output<String>) {
        this.maintenanceConfigurationId = value
    }

    /**
     * @param value The storage limit for the database elastic pool in bytes.
     */
    @JvmName("ettktwgealqghfob")
    public suspend fun maxSizeBytes(`value`: Output<Double>) {
        this.maxSizeBytes = value
    }

    /**
     * @param value Minimal capacity that serverless pool will not shrink below, if not paused
     */
    @JvmName("vlushchrypqoqhnm")
    public suspend fun minCapacity(`value`: Output<Double>) {
        this.minCapacity = value
    }

    /**
     * @param value The per database settings for the elastic pool.
     */
    @JvmName("bqiwewrsdiagbplg")
    public suspend fun perDatabaseSettings(`value`: Output<ElasticPoolPerDatabaseSettingsArgs>) {
        this.perDatabaseSettings = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("uoxhmquxmocncmbt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("axjbfrdymjbtwtif")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The elastic pool SKU.
     * The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
     * ```azurecli
     * az sql elastic-pool list-editions -l <location> -o table
     * ````
     */
    @JvmName("cpxbrifhaqxfvvun")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wthrutbntfoavogx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
     */
    @JvmName("fpuvusdfcpcfiouk")
    public suspend fun zoneRedundant(`value`: Output<Boolean>) {
        this.zoneRedundant = value
    }

    /**
     * @param value The name of the elastic pool.
     */
    @JvmName("qgemnbcjmunlfsqw")
    public suspend fun elasticPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticPoolName = mapped
    }

    /**
     * @param value The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable only to Hyperscale elastic pools.
     */
    @JvmName("skttqorwgickytkm")
    public suspend fun highAvailabilityReplicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highAvailabilityReplicaCount = mapped
    }

    /**
     * @param value The license type to apply for this elastic pool.
     */
    @JvmName("dqhhdrgkibnoufqt")
    public suspend fun licenseType(`value`: Either<String, ElasticPoolLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type to apply for this elastic pool.
     */
    @JvmName("xygoyghacrckbnsi")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ElasticPoolLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type to apply for this elastic pool.
     */
    @JvmName("qwskpqdarpevujfl")
    public fun licenseType(`value`: ElasticPoolLicenseType) {
        val toBeMapped = Either.ofRight<String, ElasticPoolLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("shcdsphhyoijfary")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur.
     */
    @JvmName("eprndriowaqwrhlr")
    public suspend fun maintenanceConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceConfigurationId = mapped
    }

    /**
     * @param value The storage limit for the database elastic pool in bytes.
     */
    @JvmName("ikbkedgphdpvftot")
    public suspend fun maxSizeBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSizeBytes = mapped
    }

    /**
     * @param value Minimal capacity that serverless pool will not shrink below, if not paused
     */
    @JvmName("gciogglnvedrbpno")
    public suspend fun minCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    /**
     * @param value The per database settings for the elastic pool.
     */
    @JvmName("ucwxmciyuppstjit")
    public suspend fun perDatabaseSettings(`value`: ElasticPoolPerDatabaseSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perDatabaseSettings = mapped
    }

    /**
     * @param argument The per database settings for the elastic pool.
     */
    @JvmName("ikgvvrnsmovdpopy")
    public suspend
    fun perDatabaseSettings(argument: suspend ElasticPoolPerDatabaseSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ElasticPoolPerDatabaseSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.perDatabaseSettings = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("fcomnyyanuqkkjwx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("sumnakcclmwewlyd")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The elastic pool SKU.
     * The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
     * ```azurecli
     * az sql elastic-pool list-editions -l <location> -o table
     * ````
     */
    @JvmName("pdjfmutdhktwbtxo")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The elastic pool SKU.
     * The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
     * ```azurecli
     * az sql elastic-pool list-editions -l <location> -o table
     * ````
     */
    @JvmName("rkrrglfijpsonytb")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vbwmywsuqxitacfk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jtqqbuvgbfkkumlp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
     */
    @JvmName("dinnpunpvrwdkgki")
    public suspend fun zoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): ElasticPoolArgs = ElasticPoolArgs(
        elasticPoolName = elasticPoolName,
        highAvailabilityReplicaCount = highAvailabilityReplicaCount,
        licenseType = licenseType,
        location = location,
        maintenanceConfigurationId = maintenanceConfigurationId,
        maxSizeBytes = maxSizeBytes,
        minCapacity = minCapacity,
        perDatabaseSettings = perDatabaseSettings,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        sku = sku,
        tags = tags,
        zoneRedundant = zoneRedundant,
    )
}
