@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EncryptionProtector].
 */
@PulumiTagMarker
public class EncryptionProtectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EncryptionProtectorArgs = EncryptionProtectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EncryptionProtectorArgsBuilder.() -> Unit) {
        val builder = EncryptionProtectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EncryptionProtector {
        val builtJavaResource = com.pulumi.azurenative.sql.EncryptionProtector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EncryptionProtector(builtJavaResource)
    }
}

/**
 * The server encryption protector.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Update the encryption protector to key vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionProtector = new AzureNative.Sql.EncryptionProtector("encryptionProtector", new()
 *     {
 *         AutoRotationEnabled = false,
 *         EncryptionProtectorName = "current",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerKeyName = "someVault_someKey_01234567890123456789012345678901",
 *         ServerKeyType = AzureNative.Sql.ServerKeyType.AzureKeyVault,
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewEncryptionProtector(ctx, "encryptionProtector", &sql.EncryptionProtectorArgs{
 * 			AutoRotationEnabled:     pulumi.Bool(false),
 * 			EncryptionProtectorName: pulumi.String("current"),
 * 			ResourceGroupName:       pulumi.String("sqlcrudtest-7398"),
 * 			ServerKeyName:           pulumi.String("someVault_someKey_01234567890123456789012345678901"),
 * 			ServerKeyType:           pulumi.String(sql.ServerKeyTypeAzureKeyVault),
 * 			ServerName:              pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.EncryptionProtector;
 * import com.pulumi.azurenative.sql.EncryptionProtectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionProtector = new EncryptionProtector("encryptionProtector", EncryptionProtectorArgs.builder()
 *             .autoRotationEnabled(false)
 *             .encryptionProtectorName("current")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverKeyName("someVault_someKey_01234567890123456789012345678901")
 *             .serverKeyType("AzureKeyVault")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ### Update the encryption protector to service managed
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionProtector = new AzureNative.Sql.EncryptionProtector("encryptionProtector", new()
 *     {
 *         EncryptionProtectorName = "current",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerKeyName = "ServiceManaged",
 *         ServerKeyType = AzureNative.Sql.ServerKeyType.ServiceManaged,
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewEncryptionProtector(ctx, "encryptionProtector", &sql.EncryptionProtectorArgs{
 * 			EncryptionProtectorName: pulumi.String("current"),
 * 			ResourceGroupName:       pulumi.String("sqlcrudtest-7398"),
 * 			ServerKeyName:           pulumi.String("ServiceManaged"),
 * 			ServerKeyType:           pulumi.String(sql.ServerKeyTypeServiceManaged),
 * 			ServerName:              pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.EncryptionProtector;
 * import com.pulumi.azurenative.sql.EncryptionProtectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionProtector = new EncryptionProtector("encryptionProtector", EncryptionProtectorArgs.builder()
 *             .encryptionProtectorName("current")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverKeyName("ServiceManaged")
 *             .serverKeyType("ServiceManaged")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:EncryptionProtector current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector/{encryptionProtectorName}
 * ```
 */
public class EncryptionProtector internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.EncryptionProtector,
) : KotlinCustomResource(javaResource, EncryptionProtectorMapper) {
    /**
     * Key auto rotation opt-in flag. Either true or false.
     */
    public val autoRotationEnabled: Output<Boolean>?
        get() = javaResource.autoRotationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of encryption protector. This is metadata used for the Azure portal experience.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the server key.
     */
    public val serverKeyName: Output<String>?
        get() = javaResource.serverKeyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     */
    public val serverKeyType: Output<String>
        get() = javaResource.serverKeyType().applyValue({ args0 -> args0 })

    /**
     * Subregion of the encryption protector.
     */
    public val subregion: Output<String>
        get() = javaResource.subregion().applyValue({ args0 -> args0 })

    /**
     * Thumbprint of the server key.
     */
    public val thumbprint: Output<String>
        get() = javaResource.thumbprint().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The URI of the server key.
     */
    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object EncryptionProtectorMapper : ResourceMapper<EncryptionProtector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.EncryptionProtector::class == javaResource::class

    override fun map(javaResource: Resource): EncryptionProtector = EncryptionProtector(
        javaResource
            as com.pulumi.azurenative.sql.EncryptionProtector,
    )
}

/**
 * @see [EncryptionProtector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EncryptionProtector].
 */
public suspend fun encryptionProtector(
    name: String,
    block: suspend EncryptionProtectorResourceBuilder.() -> Unit,
): EncryptionProtector {
    val builder = EncryptionProtectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EncryptionProtector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun encryptionProtector(name: String): EncryptionProtector {
    val builder = EncryptionProtectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
