@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GeoBackupPolicy].
 */
@PulumiTagMarker
public class GeoBackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GeoBackupPolicyArgs = GeoBackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GeoBackupPolicyArgsBuilder.() -> Unit) {
        val builder = GeoBackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GeoBackupPolicy {
        val builtJavaResource = com.pulumi.azurenative.sql.GeoBackupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GeoBackupPolicy(builtJavaResource)
    }
}

/**
 * A Geo backup policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update a database default Geo backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var geoBackupPolicy = new AzureNative.Sql.GeoBackupPolicy("geoBackupPolicy", new()
 *     {
 *         DatabaseName = "testdw",
 *         GeoBackupPolicyName = "Default",
 *         ResourceGroupName = "sqlcrudtest-4799",
 *         ServerName = "sqlcrudtest-5961",
 *         State = AzureNative.Sql.GeoBackupPolicyState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewGeoBackupPolicy(ctx, "geoBackupPolicy", &sql.GeoBackupPolicyArgs{
 * 			DatabaseName:        pulumi.String("testdw"),
 * 			GeoBackupPolicyName: pulumi.String("Default"),
 * 			ResourceGroupName:   pulumi.String("sqlcrudtest-4799"),
 * 			ServerName:          pulumi.String("sqlcrudtest-5961"),
 * 			State:               sql.GeoBackupPolicyStateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.GeoBackupPolicy;
 * import com.pulumi.azurenative.sql.GeoBackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var geoBackupPolicy = new GeoBackupPolicy("geoBackupPolicy", GeoBackupPolicyArgs.builder()
 *             .databaseName("testdw")
 *             .geoBackupPolicyName("Default")
 *             .resourceGroupName("sqlcrudtest-4799")
 *             .serverName("sqlcrudtest-5961")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:GeoBackupPolicy Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/geoBackupPolicies/{geoBackupPolicyName}
 * ```
 */
public class GeoBackupPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.GeoBackupPolicy,
) : KotlinCustomResource(javaResource, GeoBackupPolicyMapper) {
    /**
     * Kind of geo backup policy.  This is metadata used for the Azure portal experience.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Backup policy location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The state of the geo backup policy.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The storage type of the geo backup policy.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GeoBackupPolicyMapper : ResourceMapper<GeoBackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.GeoBackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): GeoBackupPolicy = GeoBackupPolicy(
        javaResource as
            com.pulumi.azurenative.sql.GeoBackupPolicy,
    )
}

/**
 * @see [GeoBackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GeoBackupPolicy].
 */
public suspend fun geoBackupPolicy(
    name: String,
    block: suspend GeoBackupPolicyResourceBuilder.() -> Unit,
): GeoBackupPolicy {
    val builder = GeoBackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GeoBackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun geoBackupPolicy(name: String): GeoBackupPolicy {
    val builder = GeoBackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
