@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.GeoBackupPolicyArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.GeoBackupPolicyState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A Geo backup policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update a database default Geo backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var geoBackupPolicy = new AzureNative.Sql.GeoBackupPolicy("geoBackupPolicy", new()
 *     {
 *         DatabaseName = "testdw",
 *         GeoBackupPolicyName = "Default",
 *         ResourceGroupName = "sqlcrudtest-4799",
 *         ServerName = "sqlcrudtest-5961",
 *         State = AzureNative.Sql.GeoBackupPolicyState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewGeoBackupPolicy(ctx, "geoBackupPolicy", &sql.GeoBackupPolicyArgs{
 * 			DatabaseName:        pulumi.String("testdw"),
 * 			GeoBackupPolicyName: pulumi.String("Default"),
 * 			ResourceGroupName:   pulumi.String("sqlcrudtest-4799"),
 * 			ServerName:          pulumi.String("sqlcrudtest-5961"),
 * 			State:               sql.GeoBackupPolicyStateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.GeoBackupPolicy;
 * import com.pulumi.azurenative.sql.GeoBackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var geoBackupPolicy = new GeoBackupPolicy("geoBackupPolicy", GeoBackupPolicyArgs.builder()
 *             .databaseName("testdw")
 *             .geoBackupPolicyName("Default")
 *             .resourceGroupName("sqlcrudtest-4799")
 *             .serverName("sqlcrudtest-5961")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:GeoBackupPolicy Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/geoBackupPolicies/{geoBackupPolicyName}
 * ```
 * @property databaseName The name of the database.
 * @property geoBackupPolicyName The name of the Geo backup policy. This should always be 'Default'.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property state The state of the geo backup policy.
 */
public data class GeoBackupPolicyArgs(
    public val databaseName: Output<String>? = null,
    public val geoBackupPolicyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val state: Output<GeoBackupPolicyState>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.GeoBackupPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.GeoBackupPolicyArgs =
        com.pulumi.azurenative.sql.GeoBackupPolicyArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .geoBackupPolicyName(geoBackupPolicyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GeoBackupPolicyArgs].
 */
@PulumiTagMarker
public class GeoBackupPolicyArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var geoBackupPolicyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var state: Output<GeoBackupPolicyState>? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("xpdgerjxhldmbhpr")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the Geo backup policy. This should always be 'Default'.
     */
    @JvmName("ismmkjqmkwtsguxd")
    public suspend fun geoBackupPolicyName(`value`: Output<String>) {
        this.geoBackupPolicyName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lvvxlxdalckxfktj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("mguodksjcgsqprnv")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The state of the geo backup policy.
     */
    @JvmName("xbdpsqeqrbidsdnu")
    public suspend fun state(`value`: Output<GeoBackupPolicyState>) {
        this.state = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("jchitajxliaunxtm")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Geo backup policy. This should always be 'Default'.
     */
    @JvmName("piemhmfyvvtbvpdi")
    public suspend fun geoBackupPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoBackupPolicyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("uxpdlfdrmasgwuim")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("crtuqdlvbecsiikg")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The state of the geo backup policy.
     */
    @JvmName("wbvnqsniqgitktqu")
    public suspend fun state(`value`: GeoBackupPolicyState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): GeoBackupPolicyArgs = GeoBackupPolicyArgs(
        databaseName = databaseName,
        geoBackupPolicyName = geoBackupPolicyName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        state = state,
    )
}
