@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LongTermRetentionPolicy].
 */
@PulumiTagMarker
public class LongTermRetentionPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LongTermRetentionPolicyArgs = LongTermRetentionPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LongTermRetentionPolicyArgsBuilder.() -> Unit) {
        val builder = LongTermRetentionPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LongTermRetentionPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.sql.LongTermRetentionPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LongTermRetentionPolicy(builtJavaResource)
    }
}

/**
 * A long term retention policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update the long term retention policy for the database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var longTermRetentionPolicy = new AzureNative.Sql.LongTermRetentionPolicy("longTermRetentionPolicy", new()
 *     {
 *         DatabaseName = "testDatabase",
 *         MonthlyRetention = "P1Y",
 *         PolicyName = "default",
 *         ResourceGroupName = "resourceGroup",
 *         ServerName = "testserver",
 *         WeekOfYear = 5,
 *         WeeklyRetention = "P1M",
 *         YearlyRetention = "P5Y",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewLongTermRetentionPolicy(ctx, "longTermRetentionPolicy", &sql.LongTermRetentionPolicyArgs{
 * 			DatabaseName:      pulumi.String("testDatabase"),
 * 			MonthlyRetention:  pulumi.String("P1Y"),
 * 			PolicyName:        pulumi.String("default"),
 * 			ResourceGroupName: pulumi.String("resourceGroup"),
 * 			ServerName:        pulumi.String("testserver"),
 * 			WeekOfYear:        pulumi.Int(5),
 * 			WeeklyRetention:   pulumi.String("P1M"),
 * 			YearlyRetention:   pulumi.String("P5Y"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.LongTermRetentionPolicy;
 * import com.pulumi.azurenative.sql.LongTermRetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var longTermRetentionPolicy = new LongTermRetentionPolicy("longTermRetentionPolicy", LongTermRetentionPolicyArgs.builder()
 *             .databaseName("testDatabase")
 *             .monthlyRetention("P1Y")
 *             .policyName("default")
 *             .resourceGroupName("resourceGroup")
 *             .serverName("testserver")
 *             .weekOfYear(5)
 *             .weeklyRetention("P1M")
 *             .yearlyRetention("P5Y")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:LongTermRetentionPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupLongTermRetentionPolicies/{policyName}
 * ```
 */
public class LongTermRetentionPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.LongTermRetentionPolicy,
) : KotlinCustomResource(javaResource, LongTermRetentionPolicyMapper) {
    /**
     * The monthly retention policy for an LTR backup in an ISO 8601 format.
     */
    public val monthlyRetention: Output<String>?
        get() = javaResource.monthlyRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The week of year to take the yearly backup in an ISO 8601 format.
     */
    public val weekOfYear: Output<Int>?
        get() = javaResource.weekOfYear().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The weekly retention policy for an LTR backup in an ISO 8601 format.
     */
    public val weeklyRetention: Output<String>?
        get() = javaResource.weeklyRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The yearly retention policy for an LTR backup in an ISO 8601 format.
     */
    public val yearlyRetention: Output<String>?
        get() = javaResource.yearlyRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LongTermRetentionPolicyMapper : ResourceMapper<LongTermRetentionPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.LongTermRetentionPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LongTermRetentionPolicy =
        LongTermRetentionPolicy(javaResource as com.pulumi.azurenative.sql.LongTermRetentionPolicy)
}

/**
 * @see [LongTermRetentionPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LongTermRetentionPolicy].
 */
public suspend fun longTermRetentionPolicy(
    name: String,
    block: suspend LongTermRetentionPolicyResourceBuilder.() -> Unit,
): LongTermRetentionPolicy {
    val builder = LongTermRetentionPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LongTermRetentionPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun longTermRetentionPolicy(name: String): LongTermRetentionPolicy {
    val builder = LongTermRetentionPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
