@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.LongTermRetentionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A long term retention policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update the long term retention policy for the database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var longTermRetentionPolicy = new AzureNative.Sql.LongTermRetentionPolicy("longTermRetentionPolicy", new()
 *     {
 *         DatabaseName = "testDatabase",
 *         MonthlyRetention = "P1Y",
 *         PolicyName = "default",
 *         ResourceGroupName = "resourceGroup",
 *         ServerName = "testserver",
 *         WeekOfYear = 5,
 *         WeeklyRetention = "P1M",
 *         YearlyRetention = "P5Y",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewLongTermRetentionPolicy(ctx, "longTermRetentionPolicy", &sql.LongTermRetentionPolicyArgs{
 * 			DatabaseName:      pulumi.String("testDatabase"),
 * 			MonthlyRetention:  pulumi.String("P1Y"),
 * 			PolicyName:        pulumi.String("default"),
 * 			ResourceGroupName: pulumi.String("resourceGroup"),
 * 			ServerName:        pulumi.String("testserver"),
 * 			WeekOfYear:        pulumi.Int(5),
 * 			WeeklyRetention:   pulumi.String("P1M"),
 * 			YearlyRetention:   pulumi.String("P5Y"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.LongTermRetentionPolicy;
 * import com.pulumi.azurenative.sql.LongTermRetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var longTermRetentionPolicy = new LongTermRetentionPolicy("longTermRetentionPolicy", LongTermRetentionPolicyArgs.builder()
 *             .databaseName("testDatabase")
 *             .monthlyRetention("P1Y")
 *             .policyName("default")
 *             .resourceGroupName("resourceGroup")
 *             .serverName("testserver")
 *             .weekOfYear(5)
 *             .weeklyRetention("P1M")
 *             .yearlyRetention("P5Y")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:LongTermRetentionPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupLongTermRetentionPolicies/{policyName}
 * ```
 * @property databaseName The name of the database.
 * @property monthlyRetention The monthly retention policy for an LTR backup in an ISO 8601 format.
 * @property policyName The policy name. Should always be Default.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property weekOfYear The week of year to take the yearly backup in an ISO 8601 format.
 * @property weeklyRetention The weekly retention policy for an LTR backup in an ISO 8601 format.
 * @property yearlyRetention The yearly retention policy for an LTR backup in an ISO 8601 format.
 */
public data class LongTermRetentionPolicyArgs(
    public val databaseName: Output<String>? = null,
    public val monthlyRetention: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val weekOfYear: Output<Int>? = null,
    public val weeklyRetention: Output<String>? = null,
    public val yearlyRetention: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.LongTermRetentionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.LongTermRetentionPolicyArgs =
        com.pulumi.azurenative.sql.LongTermRetentionPolicyArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .monthlyRetention(monthlyRetention?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .weekOfYear(weekOfYear?.applyValue({ args0 -> args0 }))
            .weeklyRetention(weeklyRetention?.applyValue({ args0 -> args0 }))
            .yearlyRetention(yearlyRetention?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LongTermRetentionPolicyArgs].
 */
@PulumiTagMarker
public class LongTermRetentionPolicyArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var monthlyRetention: Output<String>? = null

    private var policyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var weekOfYear: Output<Int>? = null

    private var weeklyRetention: Output<String>? = null

    private var yearlyRetention: Output<String>? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("lwigjoxackiwpawb")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The monthly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("wmxecmfmdmuvlnls")
    public suspend fun monthlyRetention(`value`: Output<String>) {
        this.monthlyRetention = value
    }

    /**
     * @param value The policy name. Should always be Default.
     */
    @JvmName("jubieukkiychbiad")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("saxmjxexbehakeqb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("tthsnerhaqmqktyh")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The week of year to take the yearly backup in an ISO 8601 format.
     */
    @JvmName("qkqobpcrplwqmumo")
    public suspend fun weekOfYear(`value`: Output<Int>) {
        this.weekOfYear = value
    }

    /**
     * @param value The weekly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("kbuwjoutagbytydj")
    public suspend fun weeklyRetention(`value`: Output<String>) {
        this.weeklyRetention = value
    }

    /**
     * @param value The yearly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("dfebhjjkvohfxppt")
    public suspend fun yearlyRetention(`value`: Output<String>) {
        this.yearlyRetention = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("yvcycikfnubdhfhq")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The monthly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("bvyibaeskmvjnuae")
    public suspend fun monthlyRetention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlyRetention = mapped
    }

    /**
     * @param value The policy name. Should always be Default.
     */
    @JvmName("jwdylevwoedodxhx")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("llvexvihytdncrty")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("oxuxfgonyxtqyhhl")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The week of year to take the yearly backup in an ISO 8601 format.
     */
    @JvmName("vjxtxtxbbakpothh")
    public suspend fun weekOfYear(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weekOfYear = mapped
    }

    /**
     * @param value The weekly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("waaygmqfexhrdpho")
    public suspend fun weeklyRetention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyRetention = mapped
    }

    /**
     * @param value The yearly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("qbkhgonivkwkeiin")
    public suspend fun yearlyRetention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.yearlyRetention = mapped
    }

    internal fun build(): LongTermRetentionPolicyArgs = LongTermRetentionPolicyArgs(
        databaseName = databaseName,
        monthlyRetention = monthlyRetention,
        policyName = policyName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        weekOfYear = weekOfYear,
        weeklyRetention = weeklyRetention,
        yearlyRetention = yearlyRetention,
    )
}
