@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ManagedDatabase].
 */
@PulumiTagMarker
public class ManagedDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedDatabaseArgs = ManagedDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedDatabaseArgsBuilder.() -> Unit) {
        val builder = ManagedDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedDatabase {
        val builtJavaResource = com.pulumi.azurenative.sql.ManagedDatabase(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedDatabase(builtJavaResource)
    }
}

/**
 * A managed database resource.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates a new managed database by restoring from an external backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         AutoCompleteRestore = true,
 *         Collation = "SQL_Latin1_General_CP1_CI_AS",
 *         CreateMode = AzureNative.Sql.ManagedDatabaseCreateMode.RestoreExternalBackup,
 *         DatabaseName = "managedDatabase",
 *         LastBackupName = "last_backup_name",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         StorageContainerSasToken = "sv=2015-12-11&sr=c&sp=rl&sig=1234",
 *         StorageContainerUri = "https://myaccountname.blob.core.windows.net/backups",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			AutoCompleteRestore:      pulumi.Bool(true),
 * 			Collation:                pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 			CreateMode:               pulumi.String(sql.ManagedDatabaseCreateModeRestoreExternalBackup),
 * 			DatabaseName:             pulumi.String("managedDatabase"),
 * 			LastBackupName:           pulumi.String("last_backup_name"),
 * 			Location:                 pulumi.String("southeastasia"),
 * 			ManagedInstanceName:      pulumi.String("managedInstance"),
 * 			ResourceGroupName:        pulumi.String("Default-SQL-SouthEastAsia"),
 * 			StorageContainerSasToken: pulumi.String("sv=2015-12-11&sr=c&sp=rl&sig=1234"),
 * 			StorageContainerUri:      pulumi.String("https://myaccountname.blob.core.windows.net/backups"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .autoCompleteRestore(true)
 *             .collation("SQL_Latin1_General_CP1_CI_AS")
 *             .createMode("RestoreExternalBackup")
 *             .databaseName("managedDatabase")
 *             .lastBackupName("last_backup_name")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .storageContainerSasToken("sv=2015-12-11&sr=c&sp=rl&sig=1234")
 *             .storageContainerUri("https://myaccountname.blob.core.windows.net/backups")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database from restoring a geo-replicated backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         CreateMode = AzureNative.Sql.ManagedDatabaseCreateMode.Recovery,
 *         DatabaseName = "testdb_recovered",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "server1",
 *         RecoverableDatabaseId = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/Default-SQL-WestEurope/providers/Microsoft.Sql/managedInstances/testsvr/recoverableDatabases/testdb",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			CreateMode:            pulumi.String(sql.ManagedDatabaseCreateModeRecovery),
 * 			DatabaseName:          pulumi.String("testdb_recovered"),
 * 			Location:              pulumi.String("southeastasia"),
 * 			ManagedInstanceName:   pulumi.String("server1"),
 * 			RecoverableDatabaseId: pulumi.String("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/Default-SQL-WestEurope/providers/Microsoft.Sql/managedInstances/testsvr/recoverableDatabases/testdb"),
 * 			ResourceGroupName:     pulumi.String("Default-SQL-SouthEastAsia"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .createMode("Recovery")
 *             .databaseName("testdb_recovered")
 *             .location("southeastasia")
 *             .managedInstanceName("server1")
 *             .recoverableDatabaseId("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/Default-SQL-WestEurope/providers/Microsoft.Sql/managedInstances/testsvr/recoverableDatabases/testdb")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database from restoring a long term retention backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         Collation = "SQL_Latin1_General_CP1_CI_AS",
 *         CreateMode = AzureNative.Sql.ManagedDatabaseCreateMode.RestoreExternalBackup,
 *         DatabaseName = "managedDatabase",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         StorageContainerSasToken = "sv=2015-12-11&sr=c&sp=rl&sig=1234",
 *         StorageContainerUri = "https://myaccountname.blob.core.windows.net/backups",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			Collation:                pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 			CreateMode:               pulumi.String(sql.ManagedDatabaseCreateModeRestoreExternalBackup),
 * 			DatabaseName:             pulumi.String("managedDatabase"),
 * 			Location:                 pulumi.String("southeastasia"),
 * 			ManagedInstanceName:      pulumi.String("managedInstance"),
 * 			ResourceGroupName:        pulumi.String("Default-SQL-SouthEastAsia"),
 * 			StorageContainerSasToken: pulumi.String("sv=2015-12-11&sr=c&sp=rl&sig=1234"),
 * 			StorageContainerUri:      pulumi.String("https://myaccountname.blob.core.windows.net/backups"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .collation("SQL_Latin1_General_CP1_CI_AS")
 *             .createMode("RestoreExternalBackup")
 *             .databaseName("managedDatabase")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .storageContainerSasToken("sv=2015-12-11&sr=c&sp=rl&sig=1234")
 *             .storageContainerUri("https://myaccountname.blob.core.windows.net/backups")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database using point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         CreateMode = AzureNative.Sql.ManagedDatabaseCreateMode.PointInTimeRestore,
 *         DatabaseName = "managedDatabase",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         RestorePointInTime = "2017-07-14T05:35:31.503Z",
 *         SourceDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/managedInstances/testsvr/databases/testdb",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			CreateMode:          pulumi.String(sql.ManagedDatabaseCreateModePointInTimeRestore),
 * 			DatabaseName:        pulumi.String("managedDatabase"),
 * 			Location:            pulumi.String("southeastasia"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 			RestorePointInTime:  pulumi.String("2017-07-14T05:35:31.503Z"),
 * 			SourceDatabaseId:    pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/managedInstances/testsvr/databases/testdb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .databaseName("managedDatabase")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .restorePointInTime("2017-07-14T05:35:31.503Z")
 *             .sourceDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/managedInstances/testsvr/databases/testdb")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database with maximal properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         DatabaseName = "managedDatabase",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			DatabaseName:        pulumi.String("managedDatabase"),
 * 			Location:            pulumi.String("southeastasia"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .databaseName("managedDatabase")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database with minimal properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         DatabaseName = "managedDatabase",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			DatabaseName:        pulumi.String("managedDatabase"),
 * 			Location:            pulumi.String("southeastasia"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .databaseName("managedDatabase")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedDatabase testdb1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}
 * ```
 */
public class ManagedDatabase internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ManagedDatabase,
) : KotlinCustomResource(javaResource, ManagedDatabaseMapper) {
    /**
     * Collation of the metadata catalog.
     */
    public val catalogCollation: Output<String>?
        get() = javaResource.catalogCollation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Collation of the managed database.
     */
    public val collation: Output<String>?
        get() = javaResource.collation().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Creation date of the database.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Geo paired region.
     */
    public val defaultSecondaryLocation: Output<String>
        get() = javaResource.defaultSecondaryLocation().applyValue({ args0 -> args0 })

    /**
     * Earliest restore point in time for point in time restore.
     */
    public val earliestRestorePoint: Output<String>
        get() = javaResource.earliestRestorePoint().applyValue({ args0 -> args0 })

    /**
     * Instance Failover Group resource identifier that this managed database belongs to.
     */
    public val failoverGroupId: Output<String>
        get() = javaResource.failoverGroupId().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Status of the database.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedDatabaseMapper : ResourceMapper<ManagedDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ManagedDatabase::class == javaResource::class

    override fun map(javaResource: Resource): ManagedDatabase = ManagedDatabase(
        javaResource as
            com.pulumi.azurenative.sql.ManagedDatabase,
    )
}

/**
 * @see [ManagedDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedDatabase].
 */
public suspend fun managedDatabase(
    name: String,
    block: suspend ManagedDatabaseResourceBuilder.() -> Unit,
): ManagedDatabase {
    val builder = ManagedDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedDatabase(name: String): ManagedDatabase {
    val builder = ManagedDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
