@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedDatabaseArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.CatalogCollationType
import com.pulumi.azurenative.sql.kotlin.enums.ManagedDatabaseCreateMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A managed database resource.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates a new managed database by restoring from an external backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         AutoCompleteRestore = true,
 *         Collation = "SQL_Latin1_General_CP1_CI_AS",
 *         CreateMode = AzureNative.Sql.ManagedDatabaseCreateMode.RestoreExternalBackup,
 *         DatabaseName = "managedDatabase",
 *         LastBackupName = "last_backup_name",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         StorageContainerSasToken = "sv=2015-12-11&sr=c&sp=rl&sig=1234",
 *         StorageContainerUri = "https://myaccountname.blob.core.windows.net/backups",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			AutoCompleteRestore:      pulumi.Bool(true),
 * 			Collation:                pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 			CreateMode:               pulumi.String(sql.ManagedDatabaseCreateModeRestoreExternalBackup),
 * 			DatabaseName:             pulumi.String("managedDatabase"),
 * 			LastBackupName:           pulumi.String("last_backup_name"),
 * 			Location:                 pulumi.String("southeastasia"),
 * 			ManagedInstanceName:      pulumi.String("managedInstance"),
 * 			ResourceGroupName:        pulumi.String("Default-SQL-SouthEastAsia"),
 * 			StorageContainerSasToken: pulumi.String("sv=2015-12-11&sr=c&sp=rl&sig=1234"),
 * 			StorageContainerUri:      pulumi.String("https://myaccountname.blob.core.windows.net/backups"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .autoCompleteRestore(true)
 *             .collation("SQL_Latin1_General_CP1_CI_AS")
 *             .createMode("RestoreExternalBackup")
 *             .databaseName("managedDatabase")
 *             .lastBackupName("last_backup_name")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .storageContainerSasToken("sv=2015-12-11&sr=c&sp=rl&sig=1234")
 *             .storageContainerUri("https://myaccountname.blob.core.windows.net/backups")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database from restoring a geo-replicated backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         CreateMode = AzureNative.Sql.ManagedDatabaseCreateMode.Recovery,
 *         DatabaseName = "testdb_recovered",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "server1",
 *         RecoverableDatabaseId = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/Default-SQL-WestEurope/providers/Microsoft.Sql/managedInstances/testsvr/recoverableDatabases/testdb",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			CreateMode:            pulumi.String(sql.ManagedDatabaseCreateModeRecovery),
 * 			DatabaseName:          pulumi.String("testdb_recovered"),
 * 			Location:              pulumi.String("southeastasia"),
 * 			ManagedInstanceName:   pulumi.String("server1"),
 * 			RecoverableDatabaseId: pulumi.String("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/Default-SQL-WestEurope/providers/Microsoft.Sql/managedInstances/testsvr/recoverableDatabases/testdb"),
 * 			ResourceGroupName:     pulumi.String("Default-SQL-SouthEastAsia"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .createMode("Recovery")
 *             .databaseName("testdb_recovered")
 *             .location("southeastasia")
 *             .managedInstanceName("server1")
 *             .recoverableDatabaseId("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/Default-SQL-WestEurope/providers/Microsoft.Sql/managedInstances/testsvr/recoverableDatabases/testdb")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database from restoring a long term retention backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         Collation = "SQL_Latin1_General_CP1_CI_AS",
 *         CreateMode = AzureNative.Sql.ManagedDatabaseCreateMode.RestoreExternalBackup,
 *         DatabaseName = "managedDatabase",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         StorageContainerSasToken = "sv=2015-12-11&sr=c&sp=rl&sig=1234",
 *         StorageContainerUri = "https://myaccountname.blob.core.windows.net/backups",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			Collation:                pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 			CreateMode:               pulumi.String(sql.ManagedDatabaseCreateModeRestoreExternalBackup),
 * 			DatabaseName:             pulumi.String("managedDatabase"),
 * 			Location:                 pulumi.String("southeastasia"),
 * 			ManagedInstanceName:      pulumi.String("managedInstance"),
 * 			ResourceGroupName:        pulumi.String("Default-SQL-SouthEastAsia"),
 * 			StorageContainerSasToken: pulumi.String("sv=2015-12-11&sr=c&sp=rl&sig=1234"),
 * 			StorageContainerUri:      pulumi.String("https://myaccountname.blob.core.windows.net/backups"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .collation("SQL_Latin1_General_CP1_CI_AS")
 *             .createMode("RestoreExternalBackup")
 *             .databaseName("managedDatabase")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .storageContainerSasToken("sv=2015-12-11&sr=c&sp=rl&sig=1234")
 *             .storageContainerUri("https://myaccountname.blob.core.windows.net/backups")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database using point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         CreateMode = AzureNative.Sql.ManagedDatabaseCreateMode.PointInTimeRestore,
 *         DatabaseName = "managedDatabase",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         RestorePointInTime = "2017-07-14T05:35:31.503Z",
 *         SourceDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/managedInstances/testsvr/databases/testdb",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			CreateMode:          pulumi.String(sql.ManagedDatabaseCreateModePointInTimeRestore),
 * 			DatabaseName:        pulumi.String("managedDatabase"),
 * 			Location:            pulumi.String("southeastasia"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 			RestorePointInTime:  pulumi.String("2017-07-14T05:35:31.503Z"),
 * 			SourceDatabaseId:    pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/managedInstances/testsvr/databases/testdb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .databaseName("managedDatabase")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .restorePointInTime("2017-07-14T05:35:31.503Z")
 *             .sourceDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/managedInstances/testsvr/databases/testdb")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database with maximal properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         DatabaseName = "managedDatabase",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			DatabaseName:        pulumi.String("managedDatabase"),
 * 			Location:            pulumi.String("southeastasia"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .databaseName("managedDatabase")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a new managed database with minimal properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabase = new AzureNative.Sql.ManagedDatabase("managedDatabase", new()
 *     {
 *         DatabaseName = "managedDatabase",
 *         Location = "southeastasia",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabase(ctx, "managedDatabase", &sql.ManagedDatabaseArgs{
 * 			DatabaseName:        pulumi.String("managedDatabase"),
 * 			Location:            pulumi.String("southeastasia"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabase;
 * import com.pulumi.azurenative.sql.ManagedDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabase = new ManagedDatabase("managedDatabase", ManagedDatabaseArgs.builder()
 *             .databaseName("managedDatabase")
 *             .location("southeastasia")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedDatabase testdb1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}
 * ```
 * @property autoCompleteRestore Whether to auto complete restore of this managed database.
 * @property catalogCollation Collation of the metadata catalog.
 * @property collation Collation of the managed database.
 * @property createMode Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup (longTermRetentionBackupResourceId required).
 * @property databaseName The name of the database.
 * @property lastBackupName Last backup file name for restore of this managed database.
 * @property location Resource location.
 * @property longTermRetentionBackupResourceId The name of the Long Term Retention backup to be used for restore of this managed database.
 * @property managedInstanceName The name of the managed instance.
 * @property recoverableDatabaseId The resource identifier of the recoverable database associated with create operation of this database.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property restorableDroppedDatabaseId The restorable dropped database resource id to restore when creating this database.
 * @property restorePointInTime Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
 * @property sourceDatabaseId The resource identifier of the source database associated with create operation of this database.
 * @property storageContainerSasToken Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the storage container sas token.
 * @property storageContainerUri Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container where backups for this restore are stored.
 * @property tags Resource tags.
 */
public data class ManagedDatabaseArgs(
    public val autoCompleteRestore: Output<Boolean>? = null,
    public val catalogCollation: Output<Either<String, CatalogCollationType>>? = null,
    public val collation: Output<String>? = null,
    public val createMode: Output<Either<String, ManagedDatabaseCreateMode>>? = null,
    public val databaseName: Output<String>? = null,
    public val lastBackupName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val longTermRetentionBackupResourceId: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val recoverableDatabaseId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restorableDroppedDatabaseId: Output<String>? = null,
    public val restorePointInTime: Output<String>? = null,
    public val sourceDatabaseId: Output<String>? = null,
    public val storageContainerSasToken: Output<String>? = null,
    public val storageContainerUri: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedDatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedDatabaseArgs =
        com.pulumi.azurenative.sql.ManagedDatabaseArgs.builder()
            .autoCompleteRestore(autoCompleteRestore?.applyValue({ args0 -> args0 }))
            .catalogCollation(
                catalogCollation?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .collation(collation?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .lastBackupName(lastBackupName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .longTermRetentionBackupResourceId(
                longTermRetentionBackupResourceId?.applyValue({ args0 ->
                    args0
                }),
            )
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .recoverableDatabaseId(recoverableDatabaseId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restorableDroppedDatabaseId(restorableDroppedDatabaseId?.applyValue({ args0 -> args0 }))
            .restorePointInTime(restorePointInTime?.applyValue({ args0 -> args0 }))
            .sourceDatabaseId(sourceDatabaseId?.applyValue({ args0 -> args0 }))
            .storageContainerSasToken(storageContainerSasToken?.applyValue({ args0 -> args0 }))
            .storageContainerUri(storageContainerUri?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedDatabaseArgs].
 */
@PulumiTagMarker
public class ManagedDatabaseArgsBuilder internal constructor() {
    private var autoCompleteRestore: Output<Boolean>? = null

    private var catalogCollation: Output<Either<String, CatalogCollationType>>? = null

    private var collation: Output<String>? = null

    private var createMode: Output<Either<String, ManagedDatabaseCreateMode>>? = null

    private var databaseName: Output<String>? = null

    private var lastBackupName: Output<String>? = null

    private var location: Output<String>? = null

    private var longTermRetentionBackupResourceId: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var recoverableDatabaseId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var restorableDroppedDatabaseId: Output<String>? = null

    private var restorePointInTime: Output<String>? = null

    private var sourceDatabaseId: Output<String>? = null

    private var storageContainerSasToken: Output<String>? = null

    private var storageContainerUri: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether to auto complete restore of this managed database.
     */
    @JvmName("lqeevnbwpfvatcbw")
    public suspend fun autoCompleteRestore(`value`: Output<Boolean>) {
        this.autoCompleteRestore = value
    }

    /**
     * @param value Collation of the metadata catalog.
     */
    @JvmName("xvmimpbhxqjyqoqv")
    public suspend fun catalogCollation(`value`: Output<Either<String, CatalogCollationType>>) {
        this.catalogCollation = value
    }

    /**
     * @param value Collation of the managed database.
     */
    @JvmName("soofgmwsxnppofmn")
    public suspend fun collation(`value`: Output<String>) {
        this.collation = value
    }

    /**
     * @param value Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup (longTermRetentionBackupResourceId required).
     */
    @JvmName("fdksyaeayowuuxfm")
    public suspend fun createMode(`value`: Output<Either<String, ManagedDatabaseCreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("thjxjxrwwbjedmhr")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Last backup file name for restore of this managed database.
     */
    @JvmName("wwsixvdhdypkwbli")
    public suspend fun lastBackupName(`value`: Output<String>) {
        this.lastBackupName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xngkvckcwnbvxpab")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Long Term Retention backup to be used for restore of this managed database.
     */
    @JvmName("jhvkgcilfbkdbtjn")
    public suspend fun longTermRetentionBackupResourceId(`value`: Output<String>) {
        this.longTermRetentionBackupResourceId = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("kqmvatxktoffwgrl")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The resource identifier of the recoverable database associated with create operation of this database.
     */
    @JvmName("iojttyqhfoijajji")
    public suspend fun recoverableDatabaseId(`value`: Output<String>) {
        this.recoverableDatabaseId = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dgqfjbbtbboltjpg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The restorable dropped database resource id to restore when creating this database.
     */
    @JvmName("fjnhcugxlpexwfvj")
    public suspend fun restorableDroppedDatabaseId(`value`: Output<String>) {
        this.restorableDroppedDatabaseId = value
    }

    /**
     * @param value Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
     */
    @JvmName("dgnkckqloakfpmjq")
    public suspend fun restorePointInTime(`value`: Output<String>) {
        this.restorePointInTime = value
    }

    /**
     * @param value The resource identifier of the source database associated with create operation of this database.
     */
    @JvmName("genmycqcpyamcwdg")
    public suspend fun sourceDatabaseId(`value`: Output<String>) {
        this.sourceDatabaseId = value
    }

    /**
     * @param value Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the storage container sas token.
     */
    @JvmName("jkuvtsnqokullfab")
    public suspend fun storageContainerSasToken(`value`: Output<String>) {
        this.storageContainerSasToken = value
    }

    /**
     * @param value Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container where backups for this restore are stored.
     */
    @JvmName("afickyyudgshjbuh")
    public suspend fun storageContainerUri(`value`: Output<String>) {
        this.storageContainerUri = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wyhsfqmvleocjipo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to auto complete restore of this managed database.
     */
    @JvmName("tmeddstrgeehwsfu")
    public suspend fun autoCompleteRestore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCompleteRestore = mapped
    }

    /**
     * @param value Collation of the metadata catalog.
     */
    @JvmName("dtmmeuqtwhxfpnay")
    public suspend fun catalogCollation(`value`: Either<String, CatalogCollationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogCollation = mapped
    }

    /**
     * @param value Collation of the metadata catalog.
     */
    @JvmName("uicifwostfvjjowt")
    public fun catalogCollation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CatalogCollationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogCollation = mapped
    }

    /**
     * @param value Collation of the metadata catalog.
     */
    @JvmName("qvqphcjaxwlhtniy")
    public fun catalogCollation(`value`: CatalogCollationType) {
        val toBeMapped = Either.ofRight<String, CatalogCollationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogCollation = mapped
    }

    /**
     * @param value Collation of the managed database.
     */
    @JvmName("hlfsapuaplocryxu")
    public suspend fun collation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collation = mapped
    }

    /**
     * @param value Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup (longTermRetentionBackupResourceId required).
     */
    @JvmName("asxyimngaccpnqhw")
    public suspend fun createMode(`value`: Either<String, ManagedDatabaseCreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup (longTermRetentionBackupResourceId required).
     */
    @JvmName("bcbasrfgpappyvog")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedDatabaseCreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup (longTermRetentionBackupResourceId required).
     */
    @JvmName("vkdqeliblsgyuejp")
    public fun createMode(`value`: ManagedDatabaseCreateMode) {
        val toBeMapped = Either.ofRight<String, ManagedDatabaseCreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("ntmopbjnjtwxwvag")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Last backup file name for restore of this managed database.
     */
    @JvmName("mnhfkcefvlillqmj")
    public suspend fun lastBackupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("bodhbsnxnajyvpkh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Long Term Retention backup to be used for restore of this managed database.
     */
    @JvmName("gchjcavgpxsruhfe")
    public suspend fun longTermRetentionBackupResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.longTermRetentionBackupResourceId = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("epqwtpttrgfxdcnf")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The resource identifier of the recoverable database associated with create operation of this database.
     */
    @JvmName("mpjpwnwqhpbxffbm")
    public suspend fun recoverableDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoverableDatabaseId = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nannhuhdolayxste")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The restorable dropped database resource id to restore when creating this database.
     */
    @JvmName("fviksjfgqxjrcqle")
    public suspend fun restorableDroppedDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorableDroppedDatabaseId = mapped
    }

    /**
     * @param value Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
     */
    @JvmName("ynoxsorxxdsndaom")
    public suspend fun restorePointInTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorePointInTime = mapped
    }

    /**
     * @param value The resource identifier of the source database associated with create operation of this database.
     */
    @JvmName("htwvlugybkicmlbs")
    public suspend fun sourceDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDatabaseId = mapped
    }

    /**
     * @param value Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the storage container sas token.
     */
    @JvmName("kffvjjtrimydxgqm")
    public suspend fun storageContainerSasToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerSasToken = mapped
    }

    /**
     * @param value Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container where backups for this restore are stored.
     */
    @JvmName("myjjcyhlrutfgtps")
    public suspend fun storageContainerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerUri = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lhronoujxchgjvns")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mpbhjqgrivoumlqk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedDatabaseArgs = ManagedDatabaseArgs(
        autoCompleteRestore = autoCompleteRestore,
        catalogCollation = catalogCollation,
        collation = collation,
        createMode = createMode,
        databaseName = databaseName,
        lastBackupName = lastBackupName,
        location = location,
        longTermRetentionBackupResourceId = longTermRetentionBackupResourceId,
        managedInstanceName = managedInstanceName,
        recoverableDatabaseId = recoverableDatabaseId,
        resourceGroupName = resourceGroupName,
        restorableDroppedDatabaseId = restorableDroppedDatabaseId,
        restorePointInTime = restorePointInTime,
        sourceDatabaseId = sourceDatabaseId,
        storageContainerSasToken = storageContainerSasToken,
        storageContainerUri = storageContainerUri,
        tags = tags,
    )
}
