@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
import com.pulumi.azurenative.sql.kotlin.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A database vulnerability assessment.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a database's vulnerability assessment with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabaseVulnerabilityAssessment = new AzureNative.Sql.ManagedDatabaseVulnerabilityAssessment("managedDatabaseVulnerabilityAssessment", new()
 *     {
 *         DatabaseName = "testdb",
 *         ManagedInstanceName = "vulnerabilityaseessmenttest-6440",
 *         RecurringScans = new AzureNative.Sql.Inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
 *         {
 *             EmailSubscriptionAdmins = true,
 *             Emails = new[]
 *             {
 *                 "email1@mail.com",
 *                 "email2@mail.com",
 *             },
 *             IsEnabled = true,
 *         },
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabaseVulnerabilityAssessment(ctx, "managedDatabaseVulnerabilityAssessment", &sql.ManagedDatabaseVulnerabilityAssessmentArgs{
 * 			DatabaseName:        pulumi.String("testdb"),
 * 			ManagedInstanceName: pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			RecurringScans: &sql.VulnerabilityAssessmentRecurringScansPropertiesArgs{
 * 				EmailSubscriptionAdmins: pulumi.Bool(true),
 * 				Emails: pulumi.StringArray{
 * 					pulumi.String("email1@mail.com"),
 * 					pulumi.String("email2@mail.com"),
 * 				},
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessment;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentArgs;
 * import com.pulumi.azurenative.sql.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabaseVulnerabilityAssessment = new ManagedDatabaseVulnerabilityAssessment("managedDatabaseVulnerabilityAssessment", ManagedDatabaseVulnerabilityAssessmentArgs.builder()
 *             .databaseName("testdb")
 *             .managedInstanceName("vulnerabilityaseessmenttest-6440")
 *             .recurringScans(VulnerabilityAssessmentRecurringScansPropertiesArgs.builder()
 *                 .emailSubscriptionAdmins(true)
 *                 .emails(
 *                     "email1@mail.com",
 *                     "email2@mail.com")
 *                 .isEnabled(true)
 *                 .build())
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a database's vulnerability assessment with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabaseVulnerabilityAssessment = new AzureNative.Sql.ManagedDatabaseVulnerabilityAssessment("managedDatabaseVulnerabilityAssessment", new()
 *     {
 *         DatabaseName = "testdb",
 *         ManagedInstanceName = "vulnerabilityaseessmenttest-6440",
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabaseVulnerabilityAssessment(ctx, "managedDatabaseVulnerabilityAssessment", &sql.ManagedDatabaseVulnerabilityAssessmentArgs{
 * 			DatabaseName:                pulumi.String("testdb"),
 * 			ManagedInstanceName:         pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessment;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabaseVulnerabilityAssessment = new ManagedDatabaseVulnerabilityAssessment("managedDatabaseVulnerabilityAssessment", ManagedDatabaseVulnerabilityAssessmentArgs.builder()
 *             .databaseName("testdb")
 *             .managedInstanceName("vulnerabilityaseessmenttest-6440")
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedDatabaseVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}
 * ```
 * @property databaseName The name of the database for which the vulnerability assessment is defined.
 * @property managedInstanceName The name of the managed instance.
 * @property recurringScans The recurring scans settings
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property storageAccountAccessKey Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet or a firewall
 * @property storageContainerPath A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
 * @property storageContainerSasKey A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 */
public data class ManagedDatabaseVulnerabilityAssessmentArgs(
    public val databaseName: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountAccessKey: Output<String>? = null,
    public val storageContainerPath: Output<String>? = null,
    public val storageContainerSasKey: Output<String>? = null,
    public val vulnerabilityAssessmentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentArgs =
        com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .recurringScans(recurringScans?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountAccessKey(storageAccountAccessKey?.applyValue({ args0 -> args0 }))
            .storageContainerPath(storageContainerPath?.applyValue({ args0 -> args0 }))
            .storageContainerSasKey(storageContainerSasKey?.applyValue({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedDatabaseVulnerabilityAssessmentArgs].
 */
@PulumiTagMarker
public class ManagedDatabaseVulnerabilityAssessmentArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountAccessKey: Output<String>? = null

    private var storageContainerPath: Output<String>? = null

    private var storageContainerSasKey: Output<String>? = null

    private var vulnerabilityAssessmentName: Output<String>? = null

    /**
     * @param value The name of the database for which the vulnerability assessment is defined.
     */
    @JvmName("rloqqrwwdnxxegot")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("gsmmbncsvgubxahk")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The recurring scans settings
     */
    @JvmName("bqnlvkvqikabyqyj")
    public suspend
    fun recurringScans(`value`: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>) {
        this.recurringScans = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qghlhsiauulogefk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet or a firewall
     */
    @JvmName("kbtrlmyhvvilcpqe")
    public suspend fun storageAccountAccessKey(`value`: Output<String>) {
        this.storageAccountAccessKey = value
    }

    /**
     * @param value A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
     */
    @JvmName("hgoijkujcqcomryi")
    public suspend fun storageContainerPath(`value`: Output<String>) {
        this.storageContainerPath = value
    }

    /**
     * @param value A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall
     */
    @JvmName("jiggkbwjxwvjvsuc")
    public suspend fun storageContainerSasKey(`value`: Output<String>) {
        this.storageContainerSasKey = value
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("vbxcfgosyetxrwfp")
    public suspend fun vulnerabilityAssessmentName(`value`: Output<String>) {
        this.vulnerabilityAssessmentName = value
    }

    /**
     * @param value The name of the database for which the vulnerability assessment is defined.
     */
    @JvmName("axqmwarxibarlort")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("xfqaxlyqdagmaofd")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The recurring scans settings
     */
    @JvmName("dgeylxikmlwtdvrn")
    public suspend fun recurringScans(`value`: VulnerabilityAssessmentRecurringScansPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurringScans = mapped
    }

    /**
     * @param argument The recurring scans settings
     */
    @JvmName("vosvfmobxybeljoh")
    public suspend
    fun recurringScans(argument: suspend VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.recurringScans = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("frijkxmahvmwyvpe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet or a firewall
     */
    @JvmName("cnxmviyqicwitamt")
    public suspend fun storageAccountAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountAccessKey = mapped
    }

    /**
     * @param value A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
     */
    @JvmName("ilcuvhfenlxfoqjj")
    public suspend fun storageContainerPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerPath = mapped
    }

    /**
     * @param value A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall
     */
    @JvmName("ikrdnklgnvcyggie")
    public suspend fun storageContainerSasKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerSasKey = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("hdntdsgxnrfhrkvo")
    public suspend fun vulnerabilityAssessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulnerabilityAssessmentName = mapped
    }

    internal fun build(): ManagedDatabaseVulnerabilityAssessmentArgs =
        ManagedDatabaseVulnerabilityAssessmentArgs(
            databaseName = databaseName,
            managedInstanceName = managedInstanceName,
            recurringScans = recurringScans,
            resourceGroupName = resourceGroupName,
            storageAccountAccessKey = storageAccountAccessKey,
            storageContainerPath = storageContainerPath,
            storageContainerSasKey = storageContainerSasKey,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
}
