@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs
import com.pulumi.azurenative.sql.kotlin.inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A database vulnerability assessment rule baseline.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates or updates a database's vulnerability assessment rule baseline.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabaseVulnerabilityAssessmentRuleBaseline = new AzureNative.Sql.ManagedDatabaseVulnerabilityAssessmentRuleBaseline("managedDatabaseVulnerabilityAssessmentRuleBaseline", new()
 *     {
 *         BaselineName = "default",
 *         BaselineResults = new[]
 *         {
 *             new AzureNative.Sql.Inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userA",
 *                     "SELECT",
 *                 },
 *             },
 *             new AzureNative.Sql.Inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userB",
 *                     "SELECT",
 *                 },
 *             },
 *             new AzureNative.Sql.Inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userC",
 *                     "SELECT",
 *                     "tableId_4",
 *                 },
 *             },
 *         },
 *         DatabaseName = "testdb",
 *         ManagedInstanceName = "vulnerabilityaseessmenttest-6440",
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         RuleId = "VA1001",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabaseVulnerabilityAssessmentRuleBaseline(ctx, "managedDatabaseVulnerabilityAssessmentRuleBaseline", &sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs{
 * 			BaselineName: pulumi.String("default"),
 * 			BaselineResults: sql.DatabaseVulnerabilityAssessmentRuleBaselineItemArray{
 * 				&sql.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userA"),
 * 						pulumi.String("SELECT"),
 * 					},
 * 				},
 * 				&sql.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userB"),
 * 						pulumi.String("SELECT"),
 * 					},
 * 				},
 * 				&sql.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userC"),
 * 						pulumi.String("SELECT"),
 * 						pulumi.String("tableId_4"),
 * 					},
 * 				},
 * 			},
 * 			DatabaseName:                pulumi.String("testdb"),
 * 			ManagedInstanceName:         pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			RuleId:                      pulumi.String("VA1001"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaseline;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs;
 * import com.pulumi.azurenative.sql.inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabaseVulnerabilityAssessmentRuleBaseline = new ManagedDatabaseVulnerabilityAssessmentRuleBaseline("managedDatabaseVulnerabilityAssessmentRuleBaseline", ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs.builder()
 *             .baselineName("default")
 *             .baselineResults(
 *                 DatabaseVulnerabilityAssessmentRuleBaselineItemArgs.builder()
 *                     .result(
 *                         "userA",
 *                         "SELECT")
 *                     .build(),
 *                 DatabaseVulnerabilityAssessmentRuleBaselineItemArgs.builder()
 *                     .result(
 *                         "userB",
 *                         "SELECT")
 *                     .build(),
 *                 DatabaseVulnerabilityAssessmentRuleBaselineItemArgs.builder()
 *                     .result(
 *                         "userC",
 *                         "SELECT",
 *                         "tableId_4")
 *                     .build())
 *             .databaseName("testdb")
 *             .managedInstanceName("vulnerabilityaseessmenttest-6440")
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .ruleId("VA1001")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedDatabaseVulnerabilityAssessmentRuleBaseline default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}
 * ```
 * @property baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
 * @property baselineResults The rule baseline result
 * @property databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property ruleId The vulnerability assessment rule ID.
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 */
public data class ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs(
    public val baselineName: Output<String>? = null,
    public val baselineResults: Output<List<DatabaseVulnerabilityAssessmentRuleBaselineItemArgs>>? =
        null,
    public val databaseName: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleId: Output<String>? = null,
    public val vulnerabilityAssessmentName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs =
        com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs.builder()
            .baselineName(baselineName?.applyValue({ args0 -> args0 }))
            .baselineResults(
                baselineResults?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs].
 */
@PulumiTagMarker
public class ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgsBuilder internal constructor() {
    private var baselineName: Output<String>? = null

    private var baselineResults: Output<List<DatabaseVulnerabilityAssessmentRuleBaselineItemArgs>>? =
        null

    private var databaseName: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleId: Output<String>? = null

    private var vulnerabilityAssessmentName: Output<String>? = null

    /**
     * @param value The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
     */
    @JvmName("ngqiogifhtuwgqrw")
    public suspend fun baselineName(`value`: Output<String>) {
        this.baselineName = value
    }

    /**
     * @param value The rule baseline result
     */
    @JvmName("xrfjdlxhyoybaecw")
    public suspend
    fun baselineResults(`value`: Output<List<DatabaseVulnerabilityAssessmentRuleBaselineItemArgs>>) {
        this.baselineResults = value
    }

    @JvmName("jjlffquncelbgoyr")
    public suspend fun baselineResults(
        vararg
        values: Output<DatabaseVulnerabilityAssessmentRuleBaselineItemArgs>,
    ) {
        this.baselineResults = Output.all(values.asList())
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("qaofecwdxykiprol")
    public suspend
    fun baselineResults(values: List<Output<DatabaseVulnerabilityAssessmentRuleBaselineItemArgs>>) {
        this.baselineResults = Output.all(values)
    }

    /**
     * @param value The name of the database for which the vulnerability assessment rule baseline is defined.
     */
    @JvmName("dlujsqofrnhfaawd")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("lftfvmldxwjowhnq")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nsltqbnnxsoehbxv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The vulnerability assessment rule ID.
     */
    @JvmName("hgxucflwicfdhqqw")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("bwkbtmivvowukqxl")
    public suspend fun vulnerabilityAssessmentName(`value`: Output<String>) {
        this.vulnerabilityAssessmentName = value
    }

    /**
     * @param value The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
     */
    @JvmName("lpgswoybogcoqdhf")
    public suspend fun baselineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineName = mapped
    }

    /**
     * @param value The rule baseline result
     */
    @JvmName("drotfcoydkwctncc")
    public suspend
    fun baselineResults(`value`: List<DatabaseVulnerabilityAssessmentRuleBaselineItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineResults = mapped
    }

    /**
     * @param argument The rule baseline result
     */
    @JvmName("ibeynemkxnydtdei")
    public suspend
    fun baselineResults(argument: List<suspend DatabaseVulnerabilityAssessmentRuleBaselineItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatabaseVulnerabilityAssessmentRuleBaselineItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.baselineResults = mapped
    }

    /**
     * @param argument The rule baseline result
     */
    @JvmName("ussfcfnmlmvumyhl")
    public suspend fun baselineResults(
        vararg
        argument: suspend DatabaseVulnerabilityAssessmentRuleBaselineItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DatabaseVulnerabilityAssessmentRuleBaselineItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.baselineResults = mapped
    }

    /**
     * @param argument The rule baseline result
     */
    @JvmName("wotobxvkevsnahxf")
    public suspend
    fun baselineResults(argument: suspend DatabaseVulnerabilityAssessmentRuleBaselineItemArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DatabaseVulnerabilityAssessmentRuleBaselineItemArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.baselineResults = mapped
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("xjxnrddqfebhakgu")
    public suspend fun baselineResults(
        vararg
        values: DatabaseVulnerabilityAssessmentRuleBaselineItemArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baselineResults = mapped
    }

    /**
     * @param value The name of the database for which the vulnerability assessment rule baseline is defined.
     */
    @JvmName("trfmskehfojapxmb")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("btytejqghnyiiadu")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ekfndshqfxfgioob")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vulnerability assessment rule ID.
     */
    @JvmName("ftsgyjejhkgnjpdw")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("jhejpkidlocaljuo")
    public suspend fun vulnerabilityAssessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulnerabilityAssessmentName = mapped
    }

    internal fun build(): ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs =
        ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs(
            baselineName = baselineName,
            baselineResults = baselineResults,
            databaseName = databaseName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
}
