@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstanceExternalAdministratorResponse
import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePecPropertyResponse
import com.pulumi.azurenative.sql.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.azurenative.sql.kotlin.outputs.ServicePrincipalResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstanceExternalAdministratorResponse.Companion.toKotlin as managedInstanceExternalAdministratorResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePecPropertyResponse.Companion.toKotlin as managedInstancePecPropertyResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.ServicePrincipalResponse.Companion.toKotlin as servicePrincipalResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [ManagedInstance].
 */
@PulumiTagMarker
public class ManagedInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedInstanceArgs = ManagedInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedInstanceArgsBuilder.() -> Unit) {
        val builder = ManagedInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedInstance {
        val builtJavaResource = com.pulumi.azurenative.sql.ManagedInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedInstance(builtJavaResource)
    }
}

/**
 * An Azure SQL managed instance.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2021-02-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create managed instance with all properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstance = new AzureNative.Sql.ManagedInstance("managedInstance", new()
 *     {
 *         AdministratorLogin = "dummylogin",
 *         AdministratorLoginPassword = "PLACEHOLDER",
 *         Administrators = new AzureNative.Sql.Inputs.ManagedInstanceExternalAdministratorArgs
 *         {
 *             AzureADOnlyAuthentication = true,
 *             Login = "bob@contoso.com",
 *             PrincipalType = AzureNative.Sql.PrincipalType.User,
 *             Sid = "00000011-1111-2222-2222-123456789111",
 *             TenantId = "00000011-1111-2222-2222-123456789111",
 *         },
 *         Collation = "SQL_Latin1_General_CP1_CI_AS",
 *         DnsZonePartner = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance",
 *         InstancePoolId = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/pool1",
 *         LicenseType = AzureNative.Sql.ManagedInstanceLicenseType.LicenseIncluded,
 *         Location = "Japan East",
 *         MaintenanceConfigurationId = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1",
 *         ManagedInstanceName = "testinstance",
 *         MinimalTlsVersion = "1.2",
 *         ProxyOverride = AzureNative.Sql.ManagedInstanceProxyOverride.Redirect,
 *         PublicDataEndpointEnabled = false,
 *         RequestedBackupStorageRedundancy = AzureNative.Sql.BackupStorageRedundancy.Geo,
 *         ResourceGroupName = "testrg",
 *         ServicePrincipal = new AzureNative.Sql.Inputs.ServicePrincipalArgs
 *         {
 *             Type = AzureNative.Sql.ServicePrincipalType.SystemAssigned,
 *         },
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "GP_Gen5",
 *             Tier = "GeneralPurpose",
 *         },
 *         StorageSizeInGB = 1024,
 *         SubnetId = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1",
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *         TimezoneId = "UTC",
 *         VCores = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstance(ctx, "managedInstance", &sql.ManagedInstanceArgs{
 * 			AdministratorLogin:         pulumi.String("dummylogin"),
 * 			AdministratorLoginPassword: pulumi.String("PLACEHOLDER"),
 * 			Administrators: &sql.ManagedInstanceExternalAdministratorArgs{
 * 				AzureADOnlyAuthentication: pulumi.Bool(true),
 * 				Login:                     pulumi.String("bob@contoso.com"),
 * 				PrincipalType:             pulumi.String(sql.PrincipalTypeUser),
 * 				Sid:                       pulumi.String("00000011-1111-2222-2222-123456789111"),
 * 				TenantId:                  pulumi.String("00000011-1111-2222-2222-123456789111"),
 * 			},
 * 			Collation:                        pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 			DnsZonePartner:                   pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
 * 			InstancePoolId:                   pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/pool1"),
 * 			LicenseType:                      pulumi.String(sql.ManagedInstanceLicenseTypeLicenseIncluded),
 * 			Location:                         pulumi.String("Japan East"),
 * 			MaintenanceConfigurationId:       pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
 * 			ManagedInstanceName:              pulumi.String("testinstance"),
 * 			MinimalTlsVersion:                pulumi.String("1.2"),
 * 			ProxyOverride:                    pulumi.String(sql.ManagedInstanceProxyOverrideRedirect),
 * 			PublicDataEndpointEnabled:        pulumi.Bool(false),
 * 			RequestedBackupStorageRedundancy: pulumi.String(sql.BackupStorageRedundancyGeo),
 * 			ResourceGroupName:                pulumi.String("testrg"),
 * 			ServicePrincipal: &sql.ServicePrincipalArgs{
 * 				Type: pulumi.String(sql.ServicePrincipalTypeSystemAssigned),
 * 			},
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("GP_Gen5"),
 * 				Tier: pulumi.String("GeneralPurpose"),
 * 			},
 * 			StorageSizeInGB: pulumi.Int(1024),
 * 			SubnetId:        pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 			TimezoneId: pulumi.String("UTC"),
 * 			VCores:     pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstance;
 * import com.pulumi.azurenative.sql.ManagedInstanceArgs;
 * import com.pulumi.azurenative.sql.inputs.ManagedInstanceExternalAdministratorArgs;
 * import com.pulumi.azurenative.sql.inputs.ServicePrincipalArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstance = new ManagedInstance("managedInstance", ManagedInstanceArgs.builder()
 *             .administratorLogin("dummylogin")
 *             .administratorLoginPassword("PLACEHOLDER")
 *             .administrators(ManagedInstanceExternalAdministratorArgs.builder()
 *                 .azureADOnlyAuthentication(true)
 *                 .login("bob@contoso.com")
 *                 .principalType("User")
 *                 .sid("00000011-1111-2222-2222-123456789111")
 *                 .tenantId("00000011-1111-2222-2222-123456789111")
 *                 .build())
 *             .collation("SQL_Latin1_General_CP1_CI_AS")
 *             .dnsZonePartner("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance")
 *             .instancePoolId("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/pool1")
 *             .licenseType("LicenseIncluded")
 *             .location("Japan East")
 *             .maintenanceConfigurationId("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1")
 *             .managedInstanceName("testinstance")
 *             .minimalTlsVersion("1.2")
 *             .proxyOverride("Redirect")
 *             .publicDataEndpointEnabled(false)
 *             .requestedBackupStorageRedundancy("Geo")
 *             .resourceGroupName("testrg")
 *             .servicePrincipal(ServicePrincipalArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("GP_Gen5")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storageSizeInGB(1024)
 *             .subnetId("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1")
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .timezoneId("UTC")
 *             .vCores(8)
 *             .build());
 *     }
 * }
 * ```
 * ### Create managed instance with minimal properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstance = new AzureNative.Sql.ManagedInstance("managedInstance", new()
 *     {
 *         AdministratorLogin = "dummylogin",
 *         AdministratorLoginPassword = "PLACEHOLDER",
 *         LicenseType = AzureNative.Sql.ManagedInstanceLicenseType.LicenseIncluded,
 *         Location = "Japan East",
 *         ManagedInstanceName = "testinstance",
 *         ResourceGroupName = "testrg",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "GP_Gen4",
 *             Tier = "GeneralPurpose",
 *         },
 *         StorageSizeInGB = 1024,
 *         SubnetId = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1",
 *         VCores = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstance(ctx, "managedInstance", &sql.ManagedInstanceArgs{
 * 			AdministratorLogin:         pulumi.String("dummylogin"),
 * 			AdministratorLoginPassword: pulumi.String("PLACEHOLDER"),
 * 			LicenseType:                pulumi.String(sql.ManagedInstanceLicenseTypeLicenseIncluded),
 * 			Location:                   pulumi.String("Japan East"),
 * 			ManagedInstanceName:        pulumi.String("testinstance"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("GP_Gen4"),
 * 				Tier: pulumi.String("GeneralPurpose"),
 * 			},
 * 			StorageSizeInGB: pulumi.Int(1024),
 * 			SubnetId:        pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
 * 			VCores:          pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstance;
 * import com.pulumi.azurenative.sql.ManagedInstanceArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstance = new ManagedInstance("managedInstance", ManagedInstanceArgs.builder()
 *             .administratorLogin("dummylogin")
 *             .administratorLoginPassword("PLACEHOLDER")
 *             .licenseType("LicenseIncluded")
 *             .location("Japan East")
 *             .managedInstanceName("testinstance")
 *             .resourceGroupName("testrg")
 *             .sku(SkuArgs.builder()
 *                 .name("GP_Gen4")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storageSizeInGB(1024)
 *             .subnetId("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1")
 *             .vCores(8)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstance testinstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}
 * ```
 */
public class ManagedInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ManagedInstance,
) : KotlinCustomResource(javaResource, ManagedInstanceMapper) {
    /**
     * Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
     */
    public val administratorLogin: Output<String>?
        get() = javaResource.administratorLogin().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Azure Active Directory administrator of the server.
     */
    public val administrators: Output<ManagedInstanceExternalAdministratorResponse>?
        get() = javaResource.administrators().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedInstanceExternalAdministratorResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Collation of the managed instance.
     */
    public val collation: Output<String>?
        get() = javaResource.collation().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The storage account type used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
     */
    public val currentBackupStorageRedundancy: Output<String>
        get() = javaResource.currentBackupStorageRedundancy().applyValue({ args0 -> args0 })

    /**
     * The Dns Zone that the managed instance is in.
     */
    public val dnsZone: Output<String>
        get() = javaResource.dnsZone().applyValue({ args0 -> args0 })

    /**
     * The fully qualified domain name of the managed instance.
     */
    public val fullyQualifiedDomainName: Output<String>
        get() = javaResource.fullyQualifiedDomainName().applyValue({ args0 -> args0 })

    /**
     * The Azure Active Directory identity of the managed instance.
     */
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Id of the instance pool this managed server belongs to.
     */
    public val instancePoolId: Output<String>?
        get() = javaResource.instancePoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A CMK URI of the key to use for encryption.
     */
    public val keyId: Output<String>?
        get() = javaResource.keyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     */
    public val licenseType: Output<String>?
        get() = javaResource.licenseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Specifies maintenance configuration id to apply to this managed instance.
     */
    public val maintenanceConfigurationId: Output<String>?
        get() = javaResource.maintenanceConfigurationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
     */
    public val minimalTlsVersion: Output<String>?
        get() = javaResource.minimalTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource id of a user assigned identity to be used by default.
     */
    public val primaryUserAssignedIdentityId: Output<String>?
        get() = javaResource.primaryUserAssignedIdentityId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of private endpoint connections on a managed instance.
     */
    public val privateEndpointConnections: Output<List<ManagedInstancePecPropertyResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedInstancePecPropertyResponseToKotlin(args0) })
            })
        })

    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Connection type used for connecting to the instance.
     */
    public val proxyOverride: Output<String>?
        get() = javaResource.proxyOverride().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether or not the public data endpoint is enabled.
     */
    public val publicDataEndpointEnabled: Output<Boolean>?
        get() = javaResource.publicDataEndpointEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
     */
    public val requestedBackupStorageRedundancy: Output<String>?
        get() = javaResource.requestedBackupStorageRedundancy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed instance's service principal.
     */
    public val servicePrincipal: Output<ServicePrincipalResponse>?
        get() = javaResource.servicePrincipal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> servicePrincipalResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5, BC_G8IM, BC_G8IH
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The state of the managed instance.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
     */
    public val storageSizeInGB: Output<Int>?
        get() = javaResource.storageSizeInGB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subnet resource ID for the managed instance.
     */
    public val subnetId: Output<String>?
        get() = javaResource.subnetId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Id of the timezone. Allowed values are timezones supported by Windows.
     * Windows keeps details on supported timezones, including the id, in registry under
     * KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
     * List of Ids can also be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
     * An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
     */
    public val timezoneId: Output<String>?
        get() = javaResource.timezoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     */
    public val vCores: Output<Int>?
        get() = javaResource.vCores().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether or not the multi-az is enabled.
     */
    public val zoneRedundant: Output<Boolean>?
        get() = javaResource.zoneRedundant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ManagedInstanceMapper : ResourceMapper<ManagedInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ManagedInstance::class == javaResource::class

    override fun map(javaResource: Resource): ManagedInstance = ManagedInstance(
        javaResource as
            com.pulumi.azurenative.sql.ManagedInstance,
    )
}

/**
 * @see [ManagedInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedInstance].
 */
public suspend fun managedInstance(
    name: String,
    block: suspend ManagedInstanceResourceBuilder.() -> Unit,
): ManagedInstance {
    val builder = ManagedInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedInstance(name: String): ManagedInstance {
    val builder = ManagedInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
