@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedInstanceAzureADOnlyAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Active Directory only authentication.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates or updates Azure Active Directory only authentication object.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstanceAzureADOnlyAuthentication = new AzureNative.Sql.ManagedInstanceAzureADOnlyAuthentication("managedInstanceAzureADOnlyAuthentication", new()
 *     {
 *         AuthenticationName = "Default",
 *         AzureADOnlyAuthentication = false,
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstanceAzureADOnlyAuthentication(ctx, "managedInstanceAzureADOnlyAuthentication", &sql.ManagedInstanceAzureADOnlyAuthenticationArgs{
 * 			AuthenticationName:        pulumi.String("Default"),
 * 			AzureADOnlyAuthentication: pulumi.Bool(false),
 * 			ManagedInstanceName:       pulumi.String("managedInstance"),
 * 			ResourceGroupName:         pulumi.String("Default-SQL-SouthEastAsia"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstanceAzureADOnlyAuthentication;
 * import com.pulumi.azurenative.sql.ManagedInstanceAzureADOnlyAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstanceAzureADOnlyAuthentication = new ManagedInstanceAzureADOnlyAuthentication("managedInstanceAzureADOnlyAuthentication", ManagedInstanceAzureADOnlyAuthenticationArgs.builder()
 *             .authenticationName("Default")
 *             .azureADOnlyAuthentication(false)
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstanceAzureADOnlyAuthentication Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/azureADOnlyAuthentications/{authenticationName}
 * ```
 * @property authenticationName The name of server azure active directory only authentication.
 * @property azureADOnlyAuthentication Azure Active Directory only Authentication enabled.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class ManagedInstanceAzureADOnlyAuthenticationArgs(
    public val authenticationName: Output<String>? = null,
    public val azureADOnlyAuthentication: Output<Boolean>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedInstanceAzureADOnlyAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedInstanceAzureADOnlyAuthenticationArgs =
        com.pulumi.azurenative.sql.ManagedInstanceAzureADOnlyAuthenticationArgs.builder()
            .authenticationName(authenticationName?.applyValue({ args0 -> args0 }))
            .azureADOnlyAuthentication(azureADOnlyAuthentication?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstanceAzureADOnlyAuthenticationArgs].
 */
@PulumiTagMarker
public class ManagedInstanceAzureADOnlyAuthenticationArgsBuilder internal constructor() {
    private var authenticationName: Output<String>? = null

    private var azureADOnlyAuthentication: Output<Boolean>? = null

    private var managedInstanceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of server azure active directory only authentication.
     */
    @JvmName("ccaoyqdnfjfpnjmc")
    public suspend fun authenticationName(`value`: Output<String>) {
        this.authenticationName = value
    }

    /**
     * @param value Azure Active Directory only Authentication enabled.
     */
    @JvmName("bbeaigkcwajubbxi")
    public suspend fun azureADOnlyAuthentication(`value`: Output<Boolean>) {
        this.azureADOnlyAuthentication = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("wymdemfdrxetnarg")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ccwbosawmiyaarwk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of server azure active directory only authentication.
     */
    @JvmName("ystqvutokmnrjivw")
    public suspend fun authenticationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationName = mapped
    }

    /**
     * @param value Azure Active Directory only Authentication enabled.
     */
    @JvmName("trhjxrjuweftovbx")
    public suspend fun azureADOnlyAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureADOnlyAuthentication = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("lqvhkklxixcaeula")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("pviapohemftoejhf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagedInstanceAzureADOnlyAuthenticationArgs =
        ManagedInstanceAzureADOnlyAuthenticationArgs(
            authenticationName = authenticationName,
            azureADOnlyAuthentication = azureADOnlyAuthentication,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
}
